# step1: 安装依赖（如未安装）
# pip install faiss-cpu sentence-transformers

from sentence_transformers import SentenceTransformer
import faiss
import numpy as np

# 1. 假设已有 constraint rule set
rule_set = [
    {
        "symbolic": "PutObject(?agent, ?object, ?receptacle) → Holding(?agent, ?object)",
        "description": "An agent must be holding an object before placing it on a receptacle."
    },
    {
        "symbolic": "NavigateTo(?agent, ?location) → ClearPath(?agent, ?location)",
        "description": "Agent must have a clear path before navigating to location."
    },
    {
        "symbolic": "Open(?agent, ?container) → Reachable(?agent, ?container)",
        "description": "Agent must be within reach of a container to open it."
    }
]

# 2. 选择 embedding 模型
model = SentenceTransformer('all-mpnet-base-v2')  # 可换为其他 SBERT 模型

# 3. 将每条规则编码为向量
texts = [rule["symbolic"] + ". " + rule["description"] for rule in rule_set]
embeddings = model.encode(texts, normalize_embeddings=True)
embedding_dim = embeddings.shape[1]

# 4. 构建 FAISS 索引
index = faiss.IndexFlatIP(embedding_dim)  # 使用内积作为相似度度量
index.add(np.array(embeddings))

# 5. 输入当前任务（subtask + memory）为 query
query = "Agent is trying to put a cup on the table, but not holding anything."
query_embedding = model.encode([query], normalize_embeddings=True)

# 6. 执行 Top-K 检索
K = 2
scores, indices = index.search(np.array(query_embedding), K)

# 7. 输出结果
print("\n🔍 Query:", query)
print("\n📎 Top-K Retrieved Rules:")
for i, idx in enumerate(indices[0]):
    rule = rule_set[idx]
    print(f"\n#{i+1}:")
    print("Score:", scores[0][i])
    print("Symbolic:", rule['symbolic'])
    print("Description:", rule['description'])
