import matplotlib.pyplot as plt
import numpy as np
from pathlib import Path


def plot_errorfill(x, y, yerr, color=None, alpha_fill=0.2, ax=None):
    x, y, yerr = np.array(x), np.array(y), np.array(yerr)
    ax = ax if ax is not None else plt.gca()
    if color is None:
        color = ax._get_lines.color_cycle.next()
    if np.isscalar(yerr) or len(yerr) == len(y):
        ymin = y - yerr
        ymax = y + yerr
    elif len(yerr) == 2:
        ymin, ymax = yerr
    ax.plot(x, y, color=color)
    ax.fill_between(x, ymax, ymin, color=color, alpha=alpha_fill)

def plot_reward_stepLen(stepnum_list, mean_reward_list, std_reward_list, mean_stepLen_list, std_stepLen_list, env_name, save_dir, file_suffix_name):
    fig, axs = plt.subplots(2, 1, figsize=(8, 8))

    # First subplot: Mean Reward with Standard Deviation
    axs[0].set_title('Reward - Mean with Standard Deviation ---' + env_name)
    plot_errorfill(stepnum_list, mean_reward_list, std_reward_list, color="blue", ax=axs[0])
    axs[0].set_xlabel('Timesteps')
    axs[0].set_ylabel('Reward')
    axs[0].grid(True)

    # Second subplot: Mean Step Length with Standard Deviation
    axs[1].set_title('Step Length - Mean with Standard Deviation ---' + env_name)
    plot_errorfill(stepnum_list, mean_stepLen_list, std_stepLen_list, color="blue", ax=axs[1])
    axs[1].set_xlabel('Timesteps')
    axs[1].set_ylabel('Step Length')
    axs[1].grid(True)

    plt.tight_layout()
    save_dir = Path(save_dir + "/reward_stepLen_plots_" + file_suffix_name + ".pdf")
    print("save_dir: ", save_dir)
    plt.savefig(save_dir)
    # plt.show()
    plt.close()
