import os
from pathlib import Path
from collections import defaultdict
from miditoolkit import MidiFile
import numpy as np
import pandas as pd
from tqdm import tqdm
import partitura as pt
from src.utils.midi import normalize_midi
import parangonar as pa
from copy import deepcopy
import matplotlib.pyplot as plt
import seaborn as sns
import json
from scipy.stats import pearsonr, spearmanr



if __name__ == "__main__":
    path1 = Path("data/midis/testset/human")
    path2 = Path("data/midis/testset/machine-pianist")
    path3 = Path("data/midis/testset/score")
    path4 = Path("data/midis/testset/ai-pianist")
    path5 = Path("data/midis/testset/virtuosoNet-han")
    path6 = Path("data/midis/testset/ai-pianist-no-pretrain")
    files1 = list(path1.glob("*.mid"))
    files2 = list(path2.glob("*.mid"))
    files3 = list(path3.glob("*.mid"))
    files4 = list(path4.glob("*.mid"))
    files5 = list(path5.glob("*.mid"))
    files6 = list(path6.glob("*.mid"))
    """
    for i in files1:
        i = str(i)
        normalize_midi(MidiFile(i)).dump(i.replace("testset", "testset-norm"))
    for i in files2:
        i = str(i)
        normalize_midi(MidiFile(i)).dump(i.replace("testset", "testset-norm"))
    for i in files3:
        i = str(i)
        normalize_midi(MidiFile(i)).dump(i.replace("testset", "testset-norm"))
    for i in files4:
        i = str(i)
        normalize_midi(MidiFile(i)).dump(i.replace("testset", "testset-norm"))
    for i in files5:
        i = str(i)
        normalize_midi(MidiFile(i)).dump(i.replace("testset", "testset-norm"))"""
    if not os.path.exists(str(path6).replace("testset", "testset-norm")):
        os.makedirs(str(path6).replace("testset", "testset-norm"))
    for i in files6:
        i = str(i)
        normalize_midi(MidiFile(i)).dump(i.replace("testset", "testset-norm"))
    