"""
Data generating processes

This module contains classes that generate data for the VTI project.
"""

from .abstract import AbstractDGP
from .robust_vs import RobustVS
from .lineardag import LinearDAG, MisspecifiedLinearDAG, SachsDAG
from .nonlineardag_mlp import NonLinearDAG_BatchedMLP, SachsNonLinearMLPDAG
from .diagnorm_generator import DiagNormGenerator
from .dgp_factory import create_dgp_from_key
# from .lm import LinearModel # THIS IS BROKEN

dgp_seed_fns = {
    "dgpseedfn1000": lambda s: s + 1000,
    "dgpseedfn2000": lambda s: s + 2000,
}
