"""
Callbacks to generically implement early stopping rules.
Not currently used
"""

import numpy as np
import logging


class EarlyStopping:
    """
    I should stop training if the loss hasn't improved in a while.
    """

    def __init__(self, patience=10, min_delta=0.0, verbose=False):
        """
        Args:
            patience (int): How many iterations to wait after last improvement.
            min_delta (float): Minimum change to qualify as an improvement.
            verbose (bool): If True, prints a message for each improvement.
        """
        self.patience = patience
        self.min_delta = min_delta
        self.verbose = verbose
        self.best_loss = np.Inf
        self.counter = 0
        self.early_stop = False

    def __call__(self, current_loss):
        if current_loss < self.best_loss - self.min_delta:
            self.best_loss = current_loss
            self.counter = 0
            if self.verbose:
                logging.info(f"EarlyStopping: Improved loss to {self.best_loss:.6f}")
        else:
            self.counter += 1
            if self.verbose:
                logging.info(
                    f"EarlyStopping: No improvement for {self.counter} iterations"
                )
            if self.counter >= self.patience:
                self.early_stop = True
        return self.early_stop
