import logging


class PolicyAnnealingScheduler:
    def __init__(self, T, a_0, gamma=0.9999):
        self.T = T
        logging.info(f"T = {self.T}")
        self.a_0 = a_0
        self.a = a_0
        self.gamma = gamma
        self.curT = 0

    def get(self):
        return self.a

    def step(self):
        self.curT += 1
        if self.curT == self.T:
            self.curT = 0
            self.a = self.a**self.gamma
