## ManagerBench

This directory is the code used to generate the results in the paper "ManagerBench: Evaluating the Safety-Pragmatism Trade-off in Autonomous LLMs" 



## Run Code

This code works on linux. 
To run the code, first install the requirements by running the following command:


```bash
conde env create -f environment.yml
```

To create a dataset using a given model:

```bash
python MangerBench.py --model_name model_name --step generate_examples
```

To evaluate a model on the benchmark (you can use whatever benefit and harm percentage you want, in the paper we used 10, 50 for benefit and 15, 5 for harm)
Make sure that the benchmark files are in the bench folder and run:

```bash
python MangerBench.py --model_name model_name --step final_result --benefit_percentage 50 --harm_percentage 5 
```

To see the model's harmful preference run:

```bash
python MangerBench.py --model_name model_name --step final_result --benefit_percentage 50 --harm_percentage 5  --harm_validation

```


To run the evaluation of all the results, make sure all of them are in the results folder and run:

```bash
python Results.py

```