#!/bin/bash
# set -x

# CUDA_VISIBLE_DEVICES=6 python -c "import torch; print(f'GPU 6 OK:', torch.cuda.get_device_name(0))"
# CUDA_VISIBLE_DEVICES=4 python -c "import torch; print(f'GPU 4 OK:', torch.cuda.get_device_name(0))"
# CUDA_VISIBLE_DEVICES=7 python -c "import torch; print(f'GPU 7 OK:', torch.cuda.get_device_name(0))"


GPUS=3
BATCH_SIZE=4
PER_DEVICE_BATCH_SIZE=3
GRAD_ACC=12

export PYTHONPATH="/home/ubuntu/projects/InternVL/internvl_chat:$PYTHONPATH"
export LAUNCHER=pytorch
export CUDA_VISIBLE_DEVICES=7,2,4


torchrun \
  --nnodes=1 \
  --node_rank=0 \
  --master_addr=127.0.0.1 \
  --nproc_per_node=${GPUS} \
  /home/ubuntu/projects/InternVL/internvl_chat/internvl/train/internvl_chat_finetune.py \
  --model_name_or_path "/home/ubuntu/projects/time_series_main/models/InternVL2_5-8B" \
  --conv_style "internvl2_5" \
  --use_fast_tokenizer False \
  --output_dir /home/ubuntu/projects/time_series_main/outputs/internvl_8b_finetune \
  --meta_path /home/ubuntu/projects/time_series_main/data/json/tsqa_train.json \
  --overwrite_output_dir True \
  --force_image_size 448 \
  --max_dynamic_patch 6 \
  --down_sample_ratio 0.5 \
  --freeze_llm True \
  --freeze_mlp True \
  --freeze_backbone True \
  --use_llm_lora 16 \
  --vision_select_layer -1 \
  --dataloader_num_workers 1 \
  --bf16 True \
  --num_train_epochs 3 \
  --per_device_train_batch_size ${PER_DEVICE_BATCH_SIZE} \
  --gradient_accumulation_steps ${GRAD_ACC} \
  --evaluation_strategy "no" \
  --save_strategy "steps" \
  --save_steps 200 \
  --save_total_limit 1 \
  --learning_rate 2e-5 \
  --weight_decay 0.01 \
  --warmup_ratio 0.03 \
  --lr_scheduler_type "cosine" \
  --logging_steps 1 \
  --max_seq_length 8192 \
  --do_train True \
  --grad_checkpoint True \
  --group_by_length True \
  --dynamic_image_size True \
  --use_thumbnail True \
  --ps_version 'v2' \
  --deepspeed /home/ubuntu/projects/time_series_main/internvl_chat/zero_stage1_config.json \
  --report_to "tensorboard" \
  2>&1 | tee -a outputs/internvl_8b_finetune/training_log.txt
