#!/bin/bash
set -x

GPUS=1
BATCH_SIZE=4       
PER_DEVICE_BATCH_SIZE=3
GRAD_ACC=12

export CUDA_VISIBLE_DEVICES=7
export PYTHONPATH="/home/ubuntu/projects/LLaVA:$PYTHONPATH"

torchrun \
  --nnodes=1 \
  --nproc_per_node=$GPUS \
  /home/ubuntu/projects/LLaVA/llava/train/train_mem.py \
  --deepspeed /home/ubuntu/projects/LLaVA/scripts/zero2.json \
  --model_name_or_path /home/ubuntu/projects/time_series_main/models/llava \
  --version llava_llama_2 \
  --data_path /home/ubuntu/projects/time_series_main/data/json/tsqa_train_data_filter.json \
  --image_folder /home/ubuntu/projects/time_series_main/data/plots \
  --vision_tower openai/clip-vit-large-patch14-336 \
  --mm_projector_type mlp2x_gelu \
  --mm_vision_select_layer -2 \
  --mm_use_im_start_end False \
  --mm_use_im_patch_token False \
  --image_aspect_ratio pad \
  --group_by_modality_length True \
  --bf16 True \
  --output_dir /home/ubuntu/projects/time_series_main/outputs/llava_lora_finetune_filter \
  --num_train_epochs 3 \
  --per_device_train_batch_size $PER_DEVICE_BATCH_SIZE \
  --gradient_accumulation_steps $GRAD_ACC \
  --evaluation_strategy "no" \
  --save_strategy "steps" \
  --save_steps 500 \
  --save_total_limit 1 \
  --learning_rate 2e-5 \
  --weight_decay 0.01 \
  --warmup_ratio 0.03 \
  --lr_scheduler_type "cosine" \
  --logging_steps 1 \
  --model_max_length 2048 \
  --gradient_checkpointing True \
  --dataloader_num_workers 8 \
  --lazy_preprocess True \
  --lora_enable True \
  --lora_r 16 \
  --lora_alpha 32 \
  --report_to tensorboard \
  2>&1 | tee -a /home/ubuntu/projects/time_series_main/outputs/llava_lora_finetune_filter/training_log.txt