#!/bin/bash                                                                                  
FILE=$1
OUT=$2

gunzip $FILE -c | \
cut -f 2,9-11,14,15,17,26,34 -d $'\t' | \
awk -F $'\t' 'BEGIN{OFS = FS} $5  == "single base substitution" {print $0}' | \
awk -F $'\t' 'BEGIN{OFS = FS} $9 == "WGS" {print $2, $3-1, $4, $6, $7, $1, $8}' | \
sort -V -k1,1 -k2,2 | \
uniq | \
bgzip -c > $OUT && \

tabix -p bed $OUT
   
