#!/bin/bash

IDX=$1     ## Directory of chromosome position index files
EPI=$2     ## Directory of epigenome files
REF=$3     ## Path to reference genome
MUT=$4     ## Path to mutations files
OUT=$5     ## Output directory 
WINDOW=$6  ## window size
BINS=$7    ## Number of bins
SAVE="True"

mkdir -p $OUT

for f in $(ls "$IDX"/*.pkl)
    do
        # echo $f
        name=$(basename $f .pkl)
        out=$OUT/"$name".out
        # echo $out

        # sbatch -p park --account=park_contrib --mem 2G -o $out -t 1-0:0:0 ./DataExtractor.py createChunk $f \
        sbatch -p short --mem 2G -o $out -t 0-12:0:0 ./DataExtractor.py createChunk $f \
                --epi-dir $EPI \
                --ref-file $REF \
                --mut-file $MUT \
                --out-dir $OUT \
                --window $WINDOW \
                --bins $BINS \
                --save-files $SAVE

        SAVE=False
        # sbatch -p park --account=park_contrib -
    done

