# Quality Diversity with Multi-Nodes

## Dependency

This repository contains a variety of models and tasks, each depending on different packages. Therefore, the core dependencies are kept to a minimum, and additional installations may be necessary when using certain models or tasks.

### Basic library

`pip install -r requirements.txt`

### Fishfarm
```bash
cd llama3/quality_diversity/evaluation/fishfarm
pip install -e .
```

#### VLLMModel
 `pip install vllm`

#### EvalplusTask
`pip install git+https://github.com/evalplus/evalplus@1895d2f6aa8895044a7cf69defc24bd57695e885`

#### DBBenchTask
1. Install docker
2. `docker pull mysql`
3. `pip install mysql-connector-python==8.0.32 docker==6.1.2`

#### OSInteractionTask
1. Install docker
2. `python data/os_interaction/images.py build -c data/os_interaction/configs/std.yaml -r .`

Tips 9/
* If you encounter errors connecting to MySQL containers, you may need to increase the value of `/proc/sys/fs/aio-max-nr` (like `echo 1048576 | sudo tee /proc/sys/fs/aio-max-nr`)
* `docker` package does not work with `requests==2.32.0` (see [this issue](https://github.com/docker/docker-py/issues/3256))


### Celery and Redis

`pip install celery`
`pip install redis`

## Usage

### Quick Start

#### single worker
```python
python3 main.py
```
#### many workers
1. Start rabbitmq Broker: `docker run -d -p 5672:5672 -v quality_diversity/celery_docer.conf:/etc/rabbitmq/rabbitmq.conf rabbitmq`
2. Start redis Broker: `docker run -d -p 6379:6379 -v quality_diversity/utils/redis.conf:/etc/redis/redis.conf redis redis-server /etc/redis/redis.conf`
3. Start Worker(s): `python3 main.py -m celery.mode=worker`
4. Start Main: `python3 main.py -m celery.mode=main`
