# Quality Diversity with Multi-Nodes with SAM

## SAM

### prepare SAM env
```shell
  conda create -n conv-lora python=3.10
  conda activate conv-lora
  pip install -U pip
  pip install -U setuptools wheel
  pip install autogluon
  git clone https://github.com/autogluon/autogluon
  cd autogluon && pip install -e multimodal/[tests]
```

### train SAM experts
```shell
cd autogluon/examples/automm/Conv-LoRA
python3 prepare_semantic_segmentation_datasets.py
python3 run_semantic_segmentation.py
```

## Dependency

This repository contains a variety of models and tasks, each depending on different packages. Therefore, the core dependencies are kept to a minimum, and additional installations may be necessary when using certain models or tasks.

### Basic library

`pip install -r requirements.txt`


### Celery and Redis

`pip install celery`
`pip install redis`

## Usage

### Quick Start

#### single worker
```python
python3 main.py
```
#### many workers
1. Start rabbitmq Broker: `docker run -d -p 5672:5672 -v quality_diversity/celery_docer.conf:/etc/rabbitmq/rabbitmq.conf rabbitmq`
2. Start redis Broker: `docker run -d -p 6379:6379 -v quality_diversity/utils/redis.conf:/etc/redis/redis.conf redis redis-server /etc/redis/redis.conf`
3. Start Worker(s): `python3 main.py -m celery.mode=worker`
4. Start Main: `python3 main.py -m celery.mode=main`