function [N,B,C] = Ho_Kalman_compressed(G,T1,T2,n,m,p,k,g)
% A naive implementation of the Ho-Kalman algorithm to find (A,B,C,D)
% Input: 
%     G: markov paramter
% T1,T2: dimension of Hankel matrix  -- T = T1 + T2 + 1
% n,m,p,k: system dimension
% Output: State space realization A, B, C, D
    
    
    % step 1: Hankel matrix
    H = zeros(p*T1,m*(T2+1));  % Hankel matrix
    for i = 1:T1
        for j = 1:T2+1
            H((i-1)*p+1:i*p,(j-1)*m+1:j*m) = G(:,(i+j-1)*m+1:(i+j)*m);
        end
    end
    
    % step 2: first mT2 columns of H
    Hneg = H(g*p+1:T1*p,g*m+1:(T2+1)*m);
    
    % step 3: rank-n-approximation of hH
    [U, Sigma, V] = svd(H);
    Uk = U(:,1:k);
    Sigmak = Sigma(1:k,1:k);
    Vk = V(:,1:k);
    cOhat = Uk*sqrt(Sigmak);
    cChat = sqrt(Sigmak)*Vk';
    
    N = cOhat(1:p*(T1-1),:)\cOhat(p+1:p*T1,:);
    
    C = cOhat(1:p,:)*N^(-g/2); 
    B = N^(-g/2)*cChat(:,1:m);
     
end