rng(12)
clear
n_max = 30;
n_range = 15:5:n_max;
k=4;
q = 4;
p = 4;
m = 4;
nmeas = 4;  % Number of measured outputs
ncont = 2; %control dimension
Ts = 0.1;
T = 30;
sig_x = 0.4;
sig_y = 0.4;
trail_num = 10;
trail_record = zeros(length(n_range),trail_num);
for index = 1:length(n_range)
    n = n_range(index)
    % Define the discrete-time state-space model
    eigen = zeros([1,n]);
    for i = 1:k+1
        eigen(i) = 1.01 + 0.2*rand();
    end
    for i = k+1:n
        eigen(i) = 0.5 *rand()+0.01;
    end
    eigen_diag = diag(eigen);
    Q11 = RandOrthMat(k);
    Q22 = RandOrthMat(n-k);
    Q = [Q11,zeros(k,n-k);zeros(n-k,k),Q22];
    R = inv(Q);
    A = Q*eigen_diag*R;
    %A = eigen_diag;
    [V,D] = eig(A);
    [D,I] = sort(diag(D),'descend');
    V = V(:,I);
    B = zeros([n,ncont]);
    for i = 1:k
        B(:,mod(i,ncont)+1) = B(:,mod(i,ncont)+1) + V(:,i);
    end
    C = rand(nmeas,n);
    D = zeros(nmeas,ncont);
    Q1 = Q(:,1:k);
    R1 = R(1:k,:);
    N1 = eigen_diag(1:k,1:k);
    N1 = R1*A*Q1;
    for tr = 1:trail_num
        trail = 1;
        T_open = 70;
        max_err = 100;
        while max_err > 0.98
            Y = zeros(nmeas,trail*T_open);
            Z = zeros(ncont*T_open,trail*T_open);
            for i = 1:trail    % generating trajectories
                [yi,ui,Zi]         = LTIsim(A,B,C,D,T_open,1,sig_x,sig_y);
                Y(:,(i-1)*T_open+1:i*T_open) = yi;   % prepare the data for regression
                Z(:,(i-1)*T_open+1:i*T_open) = Zi;
            end
            hG1 = Y*pinv(Z);      % least squares solution
            %% Ho-Kalman algorithm
            T1 = floor(T_open/2); T2 = T_open - T1 - 1;
            try
                [N1hat,Bhat,Chat] = Ho_Kalman_compressed(hG1,T1,T2,n,ncont,nmeas,k,m);
                plant = ss(A,B,C,D,Ts);
                sys = ss(N1hat, Bhat, Chat, 0, Ts);
                % Design the H-infinity controller
                [K, CL, gamma] = hinfsyn(sys, nmeas, ncont);
                closed_loop_system = feedback(plant,K,+1);
            catch
                %warning('control can not be created, passing');
                trail = trail+1;
                continue;
            end
            t = 0:Ts:T; % Time from 0 to 10 seconds with 0.01s time step
            u = zeros(T/Ts+1,ncont); % No external input (e.g., zero input)
            x0 = 100*ones(n,1);
            y0 = 100*ones(nmeas,1);
            % Initial condition response
            [y, t, x] = lsim(closed_loop_system, u, t, [x0;y0]);
            x_norm = zeros(length(t),1);
            for tc = 1:length(t)
                x_norm(tc) = norm(x(tc));
            end
            if isnan(x_norm(length(t)))
                trail = trail+1;
                continue
            end
            max_err = max(x_norm(length(t)-1)/max(x_norm),x_norm(length(t))/max(x_norm));
            trail = trail+1;
        end
        trail_record(index,tr) = trail-1;
    end
end
y = mean(trail_record,2); % your mean vector;
std_dev = std(trail_record,0,2);
upper = y+std_dev;
lower = y-std_dev;
long_N = [n_range,fliplr(n_range)];
inBetween = [upper',fliplr(lower')];
a = fill(long_N,inBetween, 'red');
a.FaceAlpha = 0.1;
a.EdgeColor = 'none';

fig1 = plot(n_range,y,'red', 'LineWidth',1.5);
set(gca,'YaxisLocation','origin')
axis tight
xticks('auto')
set(gca,'fontsize', 15)
legend('','','','proposed algorithm')
ylim([0 inf])
xlabel('state dimension (n)');
ylabel('number of sample trajectory');
exportgraphics(gca,'identify_traj_num.png');