﻿
# JacobiGAD: Jacobi Polynomial–Powered Heterogeneous Graph-Level Anomaly Detection

## Tested Environment

- Ubuntu 22.04
- [Python 3.9.0](https://www.anaconda.com/products/individual#Downloads)
- [Sklearn 1.6.1](https://scikit-learn.org/stable/install.html)
- [Pytorch 2.2.0](https://pytorch.org/get-started/locally/#linux-installation)
- [Numpy 1.26.4](https://numpy.org/install/)
- [Torch_geometric 2.5.1](https://pytorch-geometric.readthedocs.io/en/latest/index.html)
- [Scipy 1.13.1](https://scipy.org/)

## Datasets

First, create {dataset} directory in datasets/ to download data (e.g., download MCF-7 from TUDataset website, and put it into MCF-7 directory). 

Second, use dataset.py to preprocess datasets and generate training/validation/test set. 

**Example**

```
python dataset.py --data MCF-7 --preprocess 1 --split 1
```

**Directory Structure**

```
├── datasets
│   ├── MCF-7
│   │   ├── test.txt
│   │   ├── train.txt
│   │   ├── val.txt
│   │   ├── info.json
│   │   ├── MCF-7.pt
│   │   ├── MCF-7_A.txt
│   │   ├── MCF-7_edge_labels.txt
│   │   ├── MCF-7_graph_indicator.txt
│   │   ├── MCF-7_graph_labels.txt
│   │   ├── MCF-7_label_readme.txt
│   │   ├── MCF-7_node_labels.txt
├── dataset.py
├── config.py
├── datautils.py
```
## Experiments

**Parameters**
As described in paper. 

**Example**

```
python main.py --data MCF-7
```

**Directory Structure**

```
├── code
│	├── configs.py
│	├── lossfunc.py
│	├── main.py
│	├── model.py
│	├── utils.py
```