Minimizer_x = eye(3);

NumOfPts = 1000;
NumOfIter = 100;

toplot2 = zeros(NumOfIter, 1);
toplotlmc2 = zeros(NumOfIter, 1);
toplot = zeros(NumOfIter, 1);

tm = 0;
stt = zeros(9, 1);
for iter = 1 : NumOfIter
    lmc2 = 0;
    for i = 1 : NumOfPts
        ri = zeros(9, 1);
        for j = 1 : 9
            ri(j, 1) = store_x_LMC_005(iter, i, j);
        end 
        lmc2 = lmc2 + distance_manif_square(Minimizer_x, ri);
    end 

    tmp = 0;
    for i = 1 : NumOfPts
        ri = zeros(9, 1);
        for j = 1 : 9
            ri(j, 1) = store_x_RS(iter, i, j);
        end 
        tmp = tmp + distance_manif_square(Minimizer_x, ri);
    end 
    if iter == 1 
        ri
        distance_manif_square(Minimizer_x, ri)
    end 

    toplot2(iter, 1) = tmp/NumOfPts;
    toplotlmc2(iter, 1) = lmc2/NumOfPts;
end 

for i = 1 : NumOfIter
   toplot(i, 1) = final_value;
end 

plot(toplotlmc2, 'linewidth', 1.2)
hold on 
plot(toplot2, 'linewidth', 1.2)
hold on 
plot(toplot, 'linewidth', 1.2)

set(gca, 'YScale', 'log')
xlabel('iteration number');
ylabel('E[d(x, x^{*})^{2}]');
legend({'LMC \eta = 0.0001', 'Proximal \eta = 0.001', 'Reference'},'FontSize',10)

function y = distance_manif_square(X1, X2)
    X1 = reshape(X1, 3, 3);
    X2 = reshape(X2, 3, 3);
    X = inv(X1) * X2;
    eigs_X = eig(X);
    s = size(eigs_X);
    s = s(1);
    y = 0;
    for i = 1 : s 
        y = y + log(eigs_X(i, 1))^2;
    end
end 