kappa = 10;
dim = 5;
mu = ones(dim+1, 1);
mu(1, 1) = 5;
mu(2, 1) = 0.1;
mu(3, 1) = 2;

mean_gau = zeros(dim+1, 1);
var_gau = eye(dim+1);
total = 1000;
inner = 50;

eta = 0.02;
store_x_LMC004 = zeros(inner, total, dim+1); %for eta = 0.02

for i = 1 : total
    i
    start_pt = mvnrnd(mean_gau, var_gau);
    start_pt = start_pt / norm(start_pt);
    start_pt = start_pt';
    x_k = start_pt;
    store_x_LMC004(1, i, :) = x_k;
    for k = 1 : inner-1
        Grad =  Rie_Grad(x_k, kappa, mu);
        x_k = BM2(x_k, eta, - Grad, dim+1);
        store_x_LMC004(k+1, i, :) = x_k;
    end     
end 

eta = 0.003;
store_x_LMC = zeros(inner, total, dim+1);
for i = 1 : total
    i
    start_pt = mvnrnd(mean_gau, var_gau);
    start_pt = start_pt / norm(start_pt);
    start_pt = start_pt';
    x_k = start_pt;
    store_x_LMC(1, i, :) = x_k;
    for k = 1 : inner-1
        Grad =  Rie_Grad(x_k, kappa, mu);
        x_k = BM2(x_k, eta, - Grad, dim+1);
        store_x_LMC(k+1, i, :) = x_k;
    end     
end 

function final_pt = BM(x_k, eta, dim)
    mean_gau = zeros(dim, 1);
    var_gau = eye(dim);
    tangent = zeros(dim, dim - 1);
    parti = 1;
    for i = 1 : parti
        for d = 1 : dim - 1
            tmp = mvnrnd(mean_gau, var_gau);
            tmp = tmp';
            u = (tmp' * x_k) / norm(x_k)^2 * x_k;
            ou = tmp - u;
            for dd = 1 : d-1 
                u = (ou' * tangent(:, dd)) / norm(tangent(:, dd))^2 * tangent(:, dd);
                ou = ou - u;
            end 
            ou = ou / norm(ou);
            tangent(:, d) = ou;
        end 
        %tangent(:, 1)' * tangent(:, 2)  
        %tangent(:, 1)' * tangent(:, 3)  
        %tangent(:, 2)' * tangent(:, 3)  
        mean_rv = zeros(dim-1, 1);
        var_rv = eye(dim-1) ;
        r_v = mvnrnd(mean_rv, var_rv)';
        r = zeros(dim, 1);

        for d = 1 : dim - 1
            r = r + tangent(:, d) * r_v(d, 1);
        end 
        x_k = exp_map(x_k, (eta/parti)^(0.5) * r);
    end 
    final_pt = x_k;
end 

function final_pt = BM2(x_k, eta, grad, dim)
    x_k = exp_map(x_k, eta * grad);
    final_pt = BM(x_k, 2*eta, dim);
end 

function grad = Rie_Grad(x, kappa, mu)
    tmp = - kappa * mu;
    u = (tmp' * x) / norm(x)^2 * x;
    grad = tmp - u;
end 
function y = exp_map(x, v)
    rad = 1;
    y = x * cos(norm(v) / rad ) / rad + v/norm(v) * sin(norm(v) / rad );
end 
