kappa = 10;
dim = 5;
mu = ones(dim+1, 1);
mu(2, 1) = 0.1;
mu(1, 1) = 5;
mu(3, 1) = 2;
eta = 0.03;
t_proposal = 0.03;
t_proposal_BM = 0.08;
count_G_03 = 0;
mean_gau = zeros(dim+1, 1);
var_gau = eye(dim+1);
store = 0;
total = 1000;
inner = 50;
store_x_RS_tmp = zeros(inner, total, dim+1);
check_nan = 0;

for i = 1 : total
    i
    start_pt = mvnrnd(mean_gau, var_gau);
    start_pt = start_pt / norm(start_pt);
    start_pt = start_pt';
    x_k = start_pt;
    store_x_RS_tmp(1, i, :) = x_k;
    
    for k = 1 : inner-1
        y = BM(x_k, eta, dim, t_proposal_BM);
        x = y;
        final = 0;
        while 1
            proposal2 = R_Gauss(x, t_proposal, dim);
            [x, final] = Find_mini(y, kappa, mu, y, eta, dim);
            rho = exp(kappa * mu' * proposal2) * heat_l_eval(y, proposal2, eta, dim) / (exp(-final));
            rho = rho / exp(-acos(x' * proposal2)^2 / (2*t_proposal) );
            u = rand();
            if u < rho
                x_k = proposal2;
                break 
            end 
        end 
        store_x_RS_tmp(k+1, i, :) = x_k;
    end 
end 

function final_pt = BM(x_k, eta, dim, t_proposal_BM)
    while(1)
        u = rand();
        y = R_Gauss(x_k, t_proposal_BM, dim);
        di = acos(x_k' * y);
        rhoB = 1.9778e-2 * heat_l_eval(x_k, y, eta, dim) / exp(-di^2 / (2*t_proposal_BM));
        if rhoB > 1
            rhoB;
            continue
        end 
        if u < rhoB
            final_pt = y;
            break 
        end 
    end 
    
end 

function grad = Rie_Grad(x, kappa, mu, y, eta, dim)
    varphi = acos(x' * y);
    tmp = - kappa * mu - varphi / (eta*sqrt(1 - (x' * y)^2 )) * y ;
    u = (tmp' * x) / norm(x)^2 * x;
    grad = tmp - u;
end 

function y = exp_map(x, v)
    rad = 1;
    y = x * cos(norm(v) / rad ) / rad + v/norm(v) * sin(norm(v) / rad );
end 

function result = f_d_eval2(x, kappa, mu, y, eta, dim)
    result = - kappa * mu' * x - log(heat_l_eval(x, y, eta, dim));
end 

function result = f_d_eval(x, kappa, mu, y, eta, dim)
    varphi = acos(x' * y);
    result = - kappa * mu' * x + (varphi ^ 2 )/(2*eta);
end 

function result = heat_l_eval(z, y, t, dim)
    x = z' * y;
    T = zeros(60, 1);
    A = (2* pi^(dim/2 +1/2))/gamma(dim/2 +1/2);
    %dim = 50. S^50 in R^51
    T(1, 1) = 1; %l = 0
    T(2, 1) = 4*x;
    T(3, 1) = 12*x^2 - 2;
    T(4, 1) = 32*x^3 - 12*x; % l = 3
    T(5, 1) = 80*x^4 - 48*x^2 + 3; % l = 4
    T(6, 1) = 192*x^5 - 160*x^3 + 24*x; 
    T(7, 1) = 448*x^6 - 480*x^4 + 120*x^2 - 4; 
    T(8, 1) = 1024*x^7 - 1344*x^5 + 480*x^3 - 40*x; 
    T(9, 1) = 2304*x^8 - 3584*x^6 + 1680*x^4 - 240*x^2 + 5;
    T(10, 1) = 5120*x^9 - 9216*x^7 + 5376*x^5 - 1120*x^3 + 60*x;
    T(11, 1) = 11264*x^10 - 23040*x^8 + 16128*x^6 - 4480*x^4 + 420*x^2 - 6;
    T(12, 1) = 24576*x^11 - 56320*x^9 + 46080*x^7 - 16128*x^5 + 2240*x^3 - 84*x;
    T(13, 1) = 53248*x^12 - 135168*x^10 + 126720*x^8 - 53760*x^6 + 10080*x^4 - 672*x^2 + 7; 
    T(14, 1) = 114688*x^13 - 319488*x^11 + 337920*x^9 - 168960*x^7 + 40320*x^5 - 4032*x^3 + 112*x;
    T(15, 1) = 245760*x^14 - 745472*x^12 + 878592*x^10 - 506880*x^8 + 147840*x^6 - 20160*x^4 + 1008*x^2 - 8;
    T(16, 1) = 524288*x^15 - 1720320*x^13 + 2236416*x^11 - 1464320*x^9 + 506880*x^7 - 88704*x^5 + 6720*x^3 - 144*x;
    T(17, 1) = 1114112*x^16 - 3932160*x^14 + 5591040*x^12 - 4100096*x^10 + 1647360*x^8 - 354816*x^6 + 36960*x^4 - 1440*x^2 + 9;
    T(18, 1) = 2359296*x^17 - 8912896*x^15 + 13762560*x^13 - 11182080*x^11 + 5125120*x^9 - 1317888*x^7 + 177408*x^5 - 10560*x^3 + 180*x;
    T(19, 1) = 4980736*x^18 - 20054016*x^16 + 33423360*x^14 - 29818880*x^12 + 15375360*x^10 - 4612608*x^8 + 768768*x^6 - 63360*x^4 + 1980*x^2 - 10;
    T(20, 1) = 10485760*x^19 - 44826624*x^17 + 80216064*x^15 - 77987840*x^13 + 44728320*x^11 - 15375360*x^9 + 3075072*x^7 - 329472*x^5 + 15840*x^3 - 220*x;
    
    T(21, 1) = 22020096*x^20 - 99614720*x^18 + 190513152*x^16 - 200540160*x^14 + 126730240*x^12 - 49201152*x^10 + 11531520*x^8 - 1537536*x^6 + 102960*x^4 - 2640*x^2 + 11;
    T(22, 1) = 46137344*x^21 - 220200960*x^19 + 448266240*x^17 - 508035072*x^15 + 350945280*x^13 - 152076288*x^11 + 41000960*x^9 - 6589440*x^7 + 576576*x^5 - 22880*x^3 + 264*x; 
    T(23, 1) = 96468992*x^22 - 484442112*x^20 + 1045954560*x^18 - 1270087680*x^16 + 952565760*x^14 - 456228864*x^12 + 139403264*x^10 - 26357760*x^8 + 2882880*x^6 - 160160*x^4 + 3432*x^2 - 12;
    T(24, 1) = 201326592*x^23 - 1061158912*x^21 + 2422210560*x^19 - 3137863680*x^17 + 2540175360*x^15 - 1333592064*x^13 + 456228864*x^11 - 99573760*x^9 + 13178880*x^7 - 960960*x^5 + 32032*x^3 - 312*x;
    T(25, 1) = 419430400*x^24 - 2315255808*x^22 + 5571084288*x^20 - 7670333440*x^18 + 6667960320*x^16 - 3810263040*x^14 + 1444724736*x^12 - 358465536*x^10 + 56010240*x^8 - 5125120*x^6 + 240240*x^4 - 4368*x^2 + 13;
    T(26, 1) = 872415232*x^25 - 5033164800*x^23 + 12733906944*x^21 - 18570280960*x^19 + 17258250240*x^17 - 10668736512*x^15 + 4445306880*x^13 - 1238335488*x^11 + 224040960*x^9 - 24893440*x^7 + 1537536*x^5 - 43680*x^3 + 364*x;
    T(27, 1) = 1811939328*x^26 - 10905190400*x^24 + 28940697600*x^22 - 44568674304*x^20 + 44104417280*x^18 - 29339025408*x^16 + 13335920640*x^14 - 4127784960*x^12 + 851355648*x^10 - 112020480*x^8 + 8712704*x^6 - 349440*x^4 + 5460*x^2 - 14;
    T(28, 1) = 3758096384*x^27 - 23555211264*x^25 + 65431142400*x^23 - 106115891200*x^21 + 111421685760*x^19 - 79387951104*x^17 + 39118700544*x^15 - 13335920640*x^13 + 3095838720*x^11 - 472975360*x^9 + 44808192*x^7 - 2376192*x^5 + 58240*x^3 - 420*x;
    T(29, 1) = 7784628224*x^28 - 50734301184*x^26 + 147220070400*x^24 - 250819379200*x^22 + 278554214400*x^20 - 211701202944*x^18 + 112466264064*x^16 - 41912893440*x^14 + 10835435520*x^12 - 1891901440*x^10 + 212838912*x^8 - 14257152*x^6 + 495040*x^4 - 6720*x^2 + 15;
    T(30, 1) = 16106127360*x^29 - 108984795136*x^27 + 329772957696*x^25 - 588880281600*x^23 + 689753292800*x^21 - 557108428800*x^19 + 317551804416*x^17 - 128532873216*x^15 + 36673781760*x^13 - 7223623680*x^11 + 945950720*x^9 - 77395968*x^7 + 3564288*x^5 - 76160*x^3 + 480*x;

    T(31, 1) = 33285996544*x^30 - 233538846720*x^28 + 735647367168*x^26 - 1374053990400*x^24 + 1693030809600*x^22 - 1448481914880*x^20 + 882088345600*x^18 - 385598619648*x^16 + 120499568640*x^14 - 26486620160*x^12 + 3972993024*x^10 - 386979840*x^8 + 22573824*x^6 - 685440*x^4 + 8160*x^2 - 16;
    T(32, 1) = 68719476736*x^31 - 499289948160*x^29 + 1634771927040*x^27 - 3187805257728*x^25 + 4122161971200*x^23 - 3724667781120*x^21 + 2414136524800*x^19 - 1134113587200*x^17 + 385598619648*x^15 - 93721886720*x^13 + 15891972096*x^11 - 1805905920*x^9 + 128993280*x^7 - 5209344*x^5 + 97920*x^3 - 544*x; 
    T(33, 1) = 141733920768*x^32 - 1065151889408*x^30 + 3619852124160*x^28 - 7356473671680*x^26 + 9961891430400*x^24 - 9480972533760*x^22 + 6518168616960*x^20 - 3276328140800*x^18 + 1204995686400*x^16 - 321332183040*x^14 + 60919226368*x^12 - 7945986048*x^10 + 677214720*x^8 - 34728960*x^6 + 930240*x^4 - 9792*x^2 + 17;
    T(34, 1) = 292057776128*x^33 - 2267742732288*x^31 + 7988639170560*x^29 - 16892643246080*x^27 + 23908539432960*x^25 - 23908539432960*x^23 + 17381782978560*x^21 - 9311669452800*x^19 + 3685869158400*x^17 - 1071107276800*x^15 + 224932528128*x^13 - 33228668928*x^11 + 3310827520*x^9 - 208373760*x^7 + 7441920*x^5 - 124032*x^3 + 612*x;
    T(35, 1) = 601295421440*x^34 - 4818953306112*x^32 + 17575006175232*x^30 - 38611755991040*x^28 + 57012670955520*x^26 - 59771348582400*x^24 + 45824700579840*x^22 - 26072674467840*x^20 + 11057607475200*x^18 - 3481098649600*x^16 + 803330457600*x^14 - 132914675712*x^12 + 15229806592*x^10 - 1146055680*x^8 + 52093440*x^6 - 1240320*x^4 + 11628*x^2 - 18;
    T(36, 1) = 1236950581248*x^35 - 10222022164480*x^33 + 38551626448896*x^31 - 87875030876160*x^29 + 135141145968640*x^27 - 148232944484352*x^25 + 119542697164800*x^23 - 72010243768320*x^21 + 32590843084800*x^19 - 11057607475200*x^17 + 2784878919680*x^15 - 511210291200*x^13 + 66457337856*x^11 - 5857617920*x^9 + 327444480*x^7 - 10418688*x^5 + 155040*x^3 - 684*x;
    T(37, 1) = 2542620639232*x^36 - 21646635171840*x^34 + 84331682856960*x^32 - 199183403319296*x^30 + 318546986926080*x^28 - 364881094115328*x^26 + 308818634342400*x^24 - 196391573913600*x^22 + 94513444945920*x^20 - 34401445478400*x^18 + 9398966353920*x^16 - 1898781081600*x^14 + 276905574400*x^12 - 28116566016*x^10 + 1882805760*x^8 - 76403712*x^6 + 1627920*x^4 - 13680*x^2 + 19;
    T(38, 1) = 5222680231936*x^37 - 45767171506176*x^35 + 183996398960640*x^33 - 449768975237120*x^31 + 746937762447360*x^29 - 891931563393024*x^27 + 790575703916544*x^25 - 529403373158400*x^23 + 270038414131200*x^21 - 105014938828800*x^19 + 30961300930560*x^17 - 6835611893760*x^15 + 1107622297600*x^13 - 127802572800*x^11 + 10041630720*x^9 - 502081536*x^7 + 14325696*x^5 - 191520*x^3 + 760*x;
    T(39, 1) = 10720238370816*x^38 - 96619584290816*x^36 + 400462750679040*x^34 - 1011980194283520*x^32 + 1742854779043840*x^30 - 2166119511097344*x^28 + 2006846017634304*x^26 - 1411742328422400*x^24 + 761017348915200*x^22 - 315044816486400*x^20 + 99764191887360*x^18 - 23924641628160*x^16 + 4272257433600*x^14 - 553811148800*x^12 + 50208153600*x^10 - 3012489216*x^8 + 109830336*x^6 - 2106720*x^4 + 15960*x^2 - 20;
    T(40, 1) = 21990232555520*x^39 - 203684529045504*x^37 + 869576258617344*x^35 - 2269288920514560*x^33 + 4047920777134080*x^31 - 5228564337131520*x^29 + 5054278859227136*x^27 - 3726999747035136*x^25 + 2117613492633600*x^23 - 930132315340800*x^21 + 315044816486400*x^19 - 81625247907840*x^17 + 15949761085440*x^15 - 2300446310400*x^13 + 237347635200*x^11 - 16736051200*x^9 + 753122304*x^7 - 19381824*x^5 + 234080*x^3 - 840*x;

    T(41, 1) = 45079976738816*x^40 - 428809534832640*x^38 + 1884081893670912*x^36 - 5072528175267840*x^34 + 9360816797122560*x^32 - 12548554409115648*x^30 + 12635697148067840*x^28 - 9747537799938048*x^26 + 5823437104742400*x^24 - 2705839462809600*x^22 + 976638931107840*x^20 - 272084159692800*x^18 + 57817883934720*x^16 - 9201785241600*x^14 + 1068064358400*x^12 - 87027466240*x^10 + 4707014400*x^8 - 155054592*x^6 + 2691920*x^4 - 18480*x^2 + 21;
    T(42, 1) = 92358976733184*x^41 - 901599534776320*x^39 + 4073690580910080*x^37 - 11304491362025472*x^35 + 21558244744888320*x^33 - 29954613750792192*x^31 + 31371386022789120*x^29 - 25271394296135680*x^27 + 15839748924899328*x^25 - 7764582806323200*x^23 + 2976423409090560*x^21 - 887853573734400*x^19 + 204063119769600*x^17 - 35580236267520*x^15 + 4600892620800*x^13 - 427225743360*x^11 + 27196083200*x^9 - 1107532800*x^7 + 25842432*x^5 - 283360*x^3 + 924*x;
    T(43, 1) = 189115999977472*x^42 - 1893359023030272*x^40 + 8790595464069120*x^38 - 25121091915612160*x^36 + 49457149708861440*x^34 - 71142207658131456*x^32 + 77382752189546496*x^30 - 64983585332920320*x^28 + 42645477874728960*x^26 - 21999651284582400*x^24 + 8929270227271680*x^22 - 2841131435950080*x^20 + 702884079206400*x^18 - 133425886003200*x^16 + 19060840857600*x^14 - 1993720135680*x^12 + 146858849280*x^10 - 7198963200*x^8 + 215353600*x^6 - 3400320*x^4 + 21252*x^2 - 22;
    T(44, 1) = 387028092977152*x^43 - 3971435999526912*x^41 + 18933590230302720*x^39 - 55673771272437760*x^37 + 113044913620254720*x^35 - 168154309010128896*x^33 + 189712553755017216*x^31 - 165820183263313920*x^29 + 113721274332610560*x^27 - 61599023596830720*x^25 + 26399581541498880*x^23 - 8929270227271680*x^21 + 2367609529958400*x^19 - 486612054835200*x^17 + 76243363430400*x^15 - 8895059066880*x^13 + 747645050880*x^11 - 43193779200*x^9 + 1599769600*x^7 - 34003200*x^5 + 340032*x^3 - 1012*x;
    T(45, 1) = 791648371998720*x^44 - 8321103999008768*x^42 + 40707218995150848*x^40 - 123068336496967680*x^38 + 257491192135024640*x^36 - 395657197670891520*x^34 + 462424349777854464*x^32 - 420077797600395264*x^30 + 300549082164756480*x^28 - 170581911498915840*x^26 + 76998779496038400*x^24 - 27599562520657920*x^22 + 7813111448862720*x^20 - 1730176194969600*x^18 + 295443033292800*x^16 - 38121681715200*x^14 + 3613617745920*x^12 - 241885163520*x^10 + 10798444800*x^8 - 294694400*x^6 + 4250400*x^4 - 24288*x^2 + 23;
    T(46, 1) = 1618481116086272*x^45 - 17416264183971840*x^43 + 87371591989592064*x^41 - 271381459967672320*x^39 + 584574598360596480*x^37 - 926968291686088704*x^35 + 1121028726734192640*x^33 - 1056969942349381632*x^31 + 787645870500741120*x^29 - 467520794478510080*x^27 + 221756484948590592*x^25 - 83998668541132800*x^23 + 25299598977269760*x^21 - 6010085729894400*x^19 + 1112256125337600*x^17 - 157569617756160*x^15 + 16678235750400*x^13 - 1275394498560*x^11 + 67190323200*x^9 - 2273356800*x^7 + 44204160*x^5 - 404800*x^3 + 1104*x;
    T(47, 1) = 3307330976350208*x^46 - 36415825111941120*x^44 + 187224839977697280*x^42 - 597039211928879104*x^40 + 1322984617342402560*x^38 - 2162926013934206976*x^36 + 2703657517417758720*x^34 - 2642424855873454080*x^32 + 2047879263301926912*x^30 - 1268985013584527360*x^28 + 631153072545988608*x^26 - 251996005623398400*x^24 + 80498724018585600*x^22 - 20434291481640960*x^20 + 4078272459571200*x^18 - 630278471024640*x^16 + 73860758323200*x^14 - 6376972492800*x^12 + 389703874560*x^10 - 15913497600*x^8 + 397837440*x^6 - 5262400*x^4 + 27600*x^2 - 24;
    T(48, 1) = 6755399441055744*x^47 - 76068612456054784*x^45 + 400574076231352320*x^43 - 1310573879843880960*x^41 + 2985196059644395520*x^39 - 5027341545901129728*x^37 + 6488778041802620928*x^35 - 6566025399443128320*x^33 + 5284849711746908160*x^31 - 3413132105503211520*x^29 + 1776579019018338304*x^27 - 745908176645259264*x^25 + 251996005623398400*x^23 - 68114304938803200*x^21 + 14595922486886400*x^19 - 2446963475742720*x^17 + 315139235512320*x^15 - 30413253427200*x^13 + 2125657497600*x^11 - 102553651200*x^9 + 3182699520*x^7 - 56833920*x^5 + 478400*x^3 - 1200*x;
    T(49, 1) = 13792273858822144*x^48 - 158751886864809984*x^46 + 855771890130616320*x^44 - 2870780879658024960*x^42 + 6716691134199889920*x^40 - 11642264632613142528*x^38 + 15500969766528483328*x^36 - 16221945104506552320*x^34 + 13542427386351452160*x^32 - 9101685614675230720*x^30 + 4949041552979656704*x^28 - 2180346977886142464*x^26 + 776987684005478400*x^24 - 222919543436083200*x^22 + 51085728704102400*x^20 - 9244084241694720*x^18 + 1299949346488320*x^16 - 139032015667200*x^14 + 10982563737600*x^12 - 615321907200*x^10 + 23074571520*x^8 - 530449920*x^6 + 6458400*x^4 - 31200*x^2 + 25;
    T(50, 1) = 28147497671065600*x^49 - 331014572611731456*x^47 + 1825646698945314816*x^45 - 6275660527624519680*x^43 + 15071599618204631040*x^41 - 26866764536799559680*x^39 + 36867171336608284672*x^37 - 39859636542501814272*x^35 + 34471633347076423680*x^33 - 24075426464624803840*x^31 + 13652528422012846080*x^29 - 6298780158337744896*x^27 + 2362042559376654336*x^25 - 717219400620441600*x^23 + 175151069842636800*x^21 - 34057152469401600*x^19 + 5199797385953280*x^17 - 611740868935680*x^15 + 54068006092800*x^13 - 3468178022400*x^11 + 153830476800*x^9 - 4395156480*x^7 + 72334080*x^5 - 561600*x^3 + 1300*x;

    T(51, 1) = 57420895248973824*x^50 - 689613692941107200*x^48 + 3889421228187844608*x^46 - 13692350242089861120*x^44 + 33731675335981793280*x^42 - 61793558434638987264*x^40 + 87316984744598568960*x^38 - 97434667103893323776*x^36 + 87192954936722718720*x^34 - 63197994469640110080*x^32 + 37316911020168445952*x^30 - 17996514738107842560*x^28 + 7086127678129963008*x^26 - 2271194768631398400*x^24 + 589144507652505600*x^22 - 122605748889845760*x^20 + 20221434278707200*x^18 - 2599898692976640*x^16 + 254892028723200*x^14 - 18496949452800*x^12 + 953748956160*x^10 - 32963673600*x^8 + 699229440*x^6 - 7862400*x^4 + 35100*x^2 - 26;
    T(52, 1) = 117093590311632896*x^51 - 1435522381224345600*x^49 + 8275364315293286400*x^47 - 29818896082773475328*x^45 + 75307926331494236160*x^43 - 141673036411123531776*x^41 + 205978528115463290880*x^39 - 237003244306767544320*x^37 + 219228000983759978496*x^35 - 164697803769365135360*x^33 + 101116791151424176128*x^31 - 50886696845684244480*x^29 + 20995933861125816320*x^27 - 7086127678129963008*x^25 + 1946738373112627200*x^23 - 432039305611837440*x^21 + 76628593056153600*x^19 - 10705465206374400*x^17 + 1155510530211840*x^15 - 93907589529600*x^13 + 5549084835840*x^11 - 227083084800*x^9 + 5993395200*x^7 - 91203840*x^5 + 655200*x^3 - 1404*x;
    T(53, 1) = 238690780250636288*x^52 - 2985886552946638848*x^50 + 17585149169998233600*x^48 - 64823687136464076800*x^46 + 167731290465600798720*x^44 - 323824083225425215488*x^42 + 484049541071338733568*x^40 - 573797328321647738880*x^38 + 548070002459399946240*x^36 - 426276668579533291520*x^34 + 271751376219452473344*x^32 - 142482751167915884544*x^30 + 61488092021868462080*x^28 - 21803469778861424640*x^26 + 6326899712616038400*x^24 - 1492499419386347520*x^22 + 283525794307768320*x^20 - 42821860825497600*x^18 + 5055358569676800*x^16 - 456122577715200*x^14 + 30519966597120*x^12 - 1453331742720*x^10 + 46448812800*x^8 - 912038400*x^6 + 9500400*x^4 - 39312*x^2 + 27;
    T(54, 1) = 486388759756013568*x^53 - 6205960286516543488*x^51 + 37323581911832985600*x^49 - 140681193359985868800*x^47 + 372736201034668441600*x^45 - 738017678048643514368*x^43 + 1133384291288988254208*x^41 - 1382998688775253524480*x^39 + 1362768654763913379840*x^37 - 1096140004918799892480*x^35 + 724670336585206595584*x^33 - 395274729046476324864*x^31 + 178103438959894855680*x^29 - 66217945254319882240*x^27 + 20246079080371322880*x^25 - 5061519770092830720*x^23 + 1026093350828113920*x^21 - 166779879004569600*x^19 + 21410930412748800*x^17 - 2128572029337600*x^15 + 159642902200320*x^13 - 8719990456320*x^11 + 330302668800*x^9 - 8078054400*x^7 + 114004800*x^5 - 760032*x^3 + 1512*x;
    T(55, 1) = 990791918021509120*x^54 - 12889302133534359552*x^52 + 79125993653085929472*x^50 - 304809252279969382400*x^48 + 826502010989916979200*x^46 - 1677312904656007987200*x^44 + 2644563346340972593152*x^42 - 3319196853060608458752*x^40 + 3371059303889680465920*x^38 - 2801246679236933058560*x^36 + 1918245008607899811840*x^34 - 1087005504877809893376*x^32 + 510563191685031919616*x^30 - 198653835762959646720*x^28 + 63853018638094172160*x^26 - 16871732566976102400*x^24 + 3637967334754222080*x^22 - 633763540217364480*x^20 + 88022713919078400*x^18 - 9578574132019200*x^16 + 798214511001600*x^14 - 49413279252480*x^12 + 2179997614080*x^10 - 64624435200*x^8 + 1178049600*x^6 - 11400480*x^4 + 43848*x^2 - 28;
    T(56, 1) = 2017612633061982208*x^55 - 26751381786580746240*x^53 + 167560927735946674176*x^51 - 659383280442382745600*x^49 + 1828855513679816294400*x^47 - 3801909250553618104320*x^45 + 6150147317072029286400*x^43 - 7933690039022917779456*x^41 + 8297992132651521146880*x^39 - 7116680752655992094720*x^37 + 5042244022626479505408*x^35 - 2964560467848572436480*x^33 + 1449340673170413191168*x^31 - 589111375021190676480*x^29 + 198653835762959646720*x^27 - 55339282819681615872*x^25 + 12653799425232076800*x^23 - 2353978863664496640*x^21 + 352090855676313600*x^19 - 41694969751142400*x^17 + 3831429652807680*x^15 - 266071503667200*x^13 + 13476348887040*x^11 - 473912524800*x^9 + 10770739200*x^7 - 141365952*x^5 + 876960*x^3 - 1624*x; 
    T(57, 1) = 4107282860161892352*x^56 - 55484347409204510720*x^54 + 354455808672194887680*x^52 - 1424267885755546730496*x^50 + 4038722592709594316800*x^48 - 8595620914295136583680*x^46 + 14257159689576067891200*x^44 - 18889738188149804236800*x^42 + 20330080724996226809856*x^40 - 17978982954078295818240*x^38 + 13165859392413585375232*x^36 - 8021751854178490122240*x^34 + 4076270643291787100160*x^32 - 1728060033395492651008*x^30 + 610151066986233200640*x^28 - 178788452186663682048*x^26 + 43233814702876262400*x^24 - 8559923140598169600*x^22 + 1373154337137623040*x^20 - 176045427838156800*x^18 + 17720362144235520*x^16 - 1368367733145600*x^14 + 78612035174400*x^12 - 3222605168640*x^10 + 88858598400*x^8 - 1507903488*x^6 + 13592880*x^4 - 48720*x^2 + 29; 
    T(58, 1) = 8358680908399640576*x^57 - 115003920084532985856*x^55 + 749038690024260894720*x^53 - 3071950341825689026560*x^51 + 8901674285972167065600*x^49 - 19385868445006052720640*x^47 + 32949880171464690237440*x^45 - 44808216167239070515200*x^43 + 49585562743893236121600*x^41 - 45177957166658281799680*x^39 + 34160067612748762054656*x^37 - 21544133551222230614016*x^35 + 11364148460086194339840*x^33 - 5016948484051430277120*x^31 + 1851492892923742126080*x^29 - 569474329187150987264*x^27 + 145265617401664241664*x^25 - 30517986849089126400*x^23 + 5231064141476659200*x^21 - 722712809019801600*x^19 + 79220442527170560*x^17 - 6750614150184960*x^15 + 435389733273600*x^13 - 20507487436800*x^11 + 671376076800*x^9 - 14217375744*x^7 + 173988864*x^5 - 1006880*x^3 + 1740*x; 
    T(59, 1) = 17005592192950992896*x^58 - 238222405889389756416*x^56 + 1581303901162328555520*x^54 - 6616508428547637903360*x^52 + 19583683429138767544320*x^50 - 43618204001263618621440*x^48 + 75927984742940373155840*x^46 - 105910329122565075763200*x^44 + 120422080949455002009600*x^42 - 112944892916645704499200*x^40 + 88097016474983649509376*x^38 - 57451022803259281637376*x^36 + 31418528095532419645440*x^34 - 14423726891647862046720*x^32 + 5554478678771226378240*x^30 - 1789776463159617388544*x^28 + 480493965251658645504*x^26 - 106812953971811942400*x^24 + 19497602709140275200*x^22 - 2890851236079206400*x^20 + 343288584284405760*x^18 - 32065417213378560*x^16 + 2301345733017600*x^14 - 123044924620800*x^12 + 4699632537600*x^10 - 120847693824*x^8 + 1913877504*x^6 - 16110080*x^4 + 53940*x^2 - 30;
    T(60, 1) = 34587645138205409280*x^59 - 493162173595578793984*x^57 + 3335113682451456589824*x^55 - 14231735110460956999680*x^53 + 43007304785559646371840*x^51 - 97918417145693837721600*x^49 + 174472816005054474485760*x^47 - 249477664155375511797760*x^45 + 291253405087053958348800*x^43 - 280984855548728338022400*x^41 + 225889785833291408998400*x^39 - 152167573911335394607104*x^37 + 86176534204888922456064*x^35 - 41085767509542394920960*x^33 + 16484259304740413767680*x^31 - 5554478678771226378240*x^29 + 1566054405264665214976*x^27 - 367436561663033081856*x^25 + 71208635981207961600*x^23 - 11288085778975948800*x^21 + 1445425618039603200*x^19 - 147123678979031040*x^17 + 11660151713955840*x^15 - 700409570918400*x^13 + 30761231155200*x^11 - 939926507520*x^9 + 18591952896*x^7 - 212653056*x^5 + 1150720*x^3 - 1860*x;

    result = 0;
    for ll = 1 : 60
        l = ll - 1;
        result = result + exp(-l*(l + dim - 1)*t/2) * (2*l + dim - 1)/(dim - 1) * T(ll, 1);
    end 
    result = result / A;
    if result < 0 
        result = 0.000001;
    end
end 

function [x, final] = Find_mini(x, kappa, mu, y, eta, dim)
    initial_stepsize = 1;
    c1 = 0.0001;
    for iter = 1 : 80
        stepsize = initial_stepsize;
        ct = 0;
        for kk = 1 : 15
            
            Grad = Rie_Grad(x, kappa, mu, y, eta, dim);
            trial_pt = exp_map(x, - Grad * stepsize);
            LHS = f_d_eval(trial_pt, kappa, mu, y, eta, dim);
            RHS = f_d_eval(x, kappa, mu, y, eta, dim) + c1 * stepsize * norm(Grad)^2;
            if LHS < RHS 
                break 
            end 
            stepsize = 0.5 * stepsize;
            if isnan(LHS) == 1
                kk = 1;
                mean_gau = zeros(dim+1, 1);
                var_gau = eye(dim+1);
                tmp = mvnrnd(mean_gau, var_gau);
                x = tmp';
            end 
        end 
        toplot_grad(iter, 1) = norm(Grad);
        x = trial_pt;
        final = f_d_eval(x, kappa, mu, y, eta, dim);
        if norm(Grad) < 0.01
            %iter
            break 
        end 
    end 
    x = x / norm(x);
    final = f_d_eval2(x, kappa, mu, y, eta, dim);
end

function final_pt = R_Gauss(x_k, eta, dim)
    initial_p = x_k;
    mean_gau = zeros(dim+1, 1);
    var_gau = eye(dim+1);
    tangent = zeros(dim+1, dim);
    checkbreak = 0;
        for d = 1 : dim
            while 1
                %tangent
                tmp = mvnrnd(mean_gau, var_gau);
                tmp = tmp';
                u = (tmp' * x_k) / norm(x_k)^2 * x_k;
                ou = tmp - u;
                for dd = 1 : d-1 
                    u = (ou' * tangent(:, dd)) / norm(tangent(:, dd))^2 * tangent(:, dd);
                    ou = ou - u;
                end 
                
                if isreal(u) == 1
                    break 
                else 
                    checkbreak = 1;
                    break
                end 
            end 
            if checkbreak == 1 
                checkbreak = 0;
                d = 1;
            end 
            ou = ou / norm(ou);
            tangent(:, d) = ou;
        end 
        mean_rv = zeros(dim, 1);
        var_rv = eye(dim) ;
        r_v = mvnrnd(mean_rv, var_rv)';
        while 1
            r_v = mvnrnd(mean_rv, var_rv)';
            while norm((eta)^(0.5) * r_v) > pi 
                r_v = mvnrnd(mean_rv, var_rv)';
            end
            u = rand();
            if u < ((sin(norm((eta)^(0.5) * r_v)))/(norm((eta)^(0.5) * r_v)))^4
                break 
            end 
        end 
        
        r = zeros(dim+1, 1);
        for d = 1 : dim 
            r = r + tangent(:, d) * r_v(d, 1);
        end 
        x_k = exp_map(x_k, (eta)^(0.5) * r);
    final_pt = x_k;
    %di = acos(x_k' * initial_p)
end 
