kappa = 10;
dim = 3;
mu = ones(dim, 1);
mu(2, 1) = 0.1;
mu(1, 1) = 10;
mu(3, 1) = 2;

mean_gau = zeros(dim, 1);
var_gau = eye(dim);
store = 0;
total = 1000;
inner = 100;

eta = 0.01;
store_x_LMC = zeros(inner, total, dim);

for i = 1 : total
    i
    start_pt = mvnrnd(mean_gau, var_gau);
    start_pt = start_pt / norm(start_pt);
    start_pt = start_pt';
    x_k = start_pt;
    store_x_LMC(1, i, :) = x_k;
    for k = 1 : inner-1
        Grad =  Rie_Grad(x_k, kappa, mu);
        x_k = BM2(x_k, eta, - Grad, dim);
        store_x_LMC(k+1, i, :) = x_k;
    end 
end 

eta = 0.002;
store_x_LMC2 = zeros(inner, total, dim); % eta = 0.002

for i = 1 : total
    i
    start_pt = mvnrnd(mean_gau, var_gau);
    start_pt = start_pt / norm(start_pt);
    start_pt = start_pt';
    x_k = start_pt;
    store_x_LMC2(1, i, :) = x_k;
    for k = 1 : inner-1
        Grad =  Rie_Grad(x_k, kappa, mu);
        x_k = BM2(x_k, eta, - Grad, dim);
        store_x_LMC2(k+1, i, :) = x_k;
    end 
end 

function final_pt = BM(x_k, eta, dim)
    mean_gau = zeros(dim, 1);
    var_gau = eye(dim);
    tangent = zeros(dim, dim - 1);
    parti = 4;
    for i = 1 : parti
        for d = 1 : dim - 1
            tmp = mvnrnd(mean_gau, var_gau);
            tmp = tmp';
            u = (tmp' * x_k) / norm(x_k)^2 * x_k;
            ou = tmp - u;
            for dd = 1 : d-1 
                u = (ou' * tangent(:, dd)) / norm(tangent(:, dd))^2 * tangent(:, dd);
                ou = ou - u;
            end 
            ou = ou / norm(ou);
            tangent(:, d) = ou;
        end 
        mean_rv = zeros(dim-1, 1);
        var_rv = eye(dim-1) ;
        r_v = mvnrnd(mean_rv, var_rv)';
        r = zeros(dim, 1);

        for d = 1 : dim - 1
            r = r + tangent(:, d) * r_v(d, 1);
        end 
        x_k = exp_map(x_k, (eta/parti)^(0.5) * r);
    end 
    final_pt = x_k;
end 

function final_pt = BM2(x_k, eta, grad, dim)
    x_k = exp_map(x_k, eta * grad);
    final_pt = BM(x_k, 2*eta, dim);
end 

function grad = Rie_Grad(x, kappa, mu)
    tmp = - kappa * mu;
    u = (tmp' * x) / norm(x)^2 * x;
    grad = tmp - u;
end 
function y = exp_map(x, v)
    rad = 1;
    y = x * cos(norm(v) / rad ) / rad + v/norm(v) * sin(norm(v) / rad );
end 
