import openvino as ov
import time
import numpy as np
import os

xml_file = f"./inception_v3.xml"

core = ov.Core()
print(f'devices {core.available_devices}')
model = core.read_model(model=xml_file)
# print(f'devices {core.available_devices}')

devices = ['GPU.1']
# devices = ['CPU', 'GPU.0', 'GPU.1']
input_data = np.random.randn(1, 3, 299, 299)

for device in devices:

    compiled_model = core.compile_model(model, device)
    input_layer = compiled_model.input(0)
    output_layer = compiled_model.output(0)
    

    input_data = np.random.randn(1, 3, 299, 299)
    run_times = []
    for i in range(10):
        start_time = time.perf_counter()
        output = compiled_model({input_layer.any_name: input_data})[output_layer]
        end_time = time.perf_counter()
        run_time = end_time - start_time
        if i >4:
            run_times.append(run_time)

    run_time_mean = np.mean(run_times)

    print(f'{device} run_time {run_time_mean}')



core = ov.Core()
model = core.read_model(model=xml_file)
ops = model.get_ops()

for i, op in enumerate(ops):
    affinity = "CPU" if i == 0 else "GPU.1"
    # affinity = "CPU" if ((p[node] == 0) or (p[node] == 1)) else "GPU.1"
    ops[i].get_rt_info()["affinity"] = affinity

compiled_model = core.compile_model(model, "HETERO:GPU,CPU")

input_layer = compiled_model.input(0)
output_layer = compiled_model.output(0)

input_data = np.random.randn(1, 3, 299, 299)

run_times = []
for i in range(10):
    start_time = time.perf_counter()
    output = compiled_model({input_layer.any_name: input_data})[output_layer]
    end_time = time.perf_counter()
    run_time = end_time - start_time
    if i > 4:
        run_times.append(run_time)

run_time_mean = np.mean(run_times)
print(f'run_time {run_time_mean}')



