import openvino as ov
import time
import numpy as np

xml_file = f"/home/shukai/projects/Heterogeneous-Computing/GPN_OpenVINO/resnet50.xml"

core = ov.Core()
print(f'devices {core.available_devices}')
model = core.read_model(model=xml_file)

devices = ['CPU', 'GPU.0', 'GPU.1', 'HETERO:CPU,GPU.1']
# input_data = np.random.randn(1, 3, 224, 224)

for device in devices:

    compiled_model = core.compile_model(model, device)
    input_layer = compiled_model.input(0)
    output_layer = compiled_model.output(0)

    input_data = np.random.randn(1, 3, 224, 224)
    run_times = []
    for i in range(10):
        start_time = time.perf_counter()
        output = compiled_model({input_layer.any_name: input_data})[output_layer]
        end_time = time.perf_counter()
        run_time = end_time - start_time
        if i >4:
            run_times.append(run_time)

    run_time_mean = np.mean(run_times)

    print(f'{device} run_time {run_time_mean}')

