DATA=$1
SHOT=$2
GPU=$3
LAYERS=$4
CKPT=$5
REFINE=$6 # Flag to perform keyframe finetuning
MULTISPRT=$7 # Flag specific to ytvis to enable multiple support per class

SPLITS="0 1 2 3"
NRUNS=5
run=test_nonbatched_meta
test_num=0

for SPLIT in $SPLITS
do
	dirname="results/test/arch=resnet-${LAYERS}/data=${DATA}/shot=shot_${SHOT}/ckpt=${CKPT}/refine=${REFINE}/multisprt=${MULTISPRT}/split=split_${SPLIT}"
	mkdir -p -- "$dirname"
	python3 -m src.$run --config config_files/${DATA}.yaml \
						--opts train_split ${SPLIT} \
							   shot ${SHOT} \
							   layers ${LAYERS} \
							   FB_param_update "[10]" \
							   temperature 20.0 \
							   adapt_iter 50 \
							   cls_lr 0.025 \
							   gpus ${GPU} \
							   test_num $test_num \
							   n_runs ${NRUNS} \
                               weights "[1.0,'auto','auto','auto']"\
                               workers 0 \
                               selected_weights "[]" \
                               ckpt_path ${CKPT} \
                               refine_keyframes_ftune ${REFINE} \
                               multi_rnd_sprt ${MULTISPRT} 
done
