% min_X 0.5*mdot(X,C*X) + lambda*||X(:)||_0
clc;clear all;close all;
maxNumCompThreads(1);
addpath('util','solver','../data');
rand('seed',0); randn('seed',0);

lambda  = 500;

time_list   = [60];
data_list   = [1:10];
r_list      = [20];
lambda_list = lambda;




result = [];
for i_data_list = 1:length(data_list)
    
    r = r_list(1);
    lambda = lambda_list(1);
    time_limit = time_list(1);
    idat = data_list(i_data_list);
    dat_x = GetData(idat);
    [m,n] = size(dat_x);
    C = - dat_x'*dat_x;
    fprintf('================= start =================\n');
    fprintf(' time_limit: %d\n',time_limit);
    fprintf('       data: %d\n',idat);
    fprintf('          r: %d\n',r);
    fprintf('     lambda: %d\n',lambda);
    fprintf('          m: %d\n',size(dat_x,1));
    fprintf('          n: %d\n',size(dat_x,2));
    fprintf('sparsity(I): %f\n',(r)/(n*r));
    X0 = eye(n,r);
    [X00, ~] = qr(randn(n,r), 0);
    
    HandleTrueObj = @(X)ComputeTrueObjL0PCA(X,C,lambda,1e-5);
    
    [X1,his1,ts1] = ADMM_L0PCA(0.5*C,lambda,r,X0,1e7,time_limit,HandleTrueObj);
    [X2,his2,ts2] = RADMM_L0PCA(0.5*C,lambda,r,X0,1e7,time_limit,HandleTrueObj);
    [X3,his3,ts3] = PADM_L0PCA(0.5*C,lambda,r,X0,1e7,time_limit,HandleTrueObj);
    [X4,his4,ts4] = ADMM_L0PCA(0.5*C,lambda,r,X00,1e7,time_limit,HandleTrueObj);
    [X5,his5,ts5] = RADMM_L0PCA(0.5*C,lambda,r,X00,1e7,time_limit,HandleTrueObj);
    [X6,his6,ts6] = PADM_L0PCA(0.5*C,lambda,r,X00,1e7,time_limit,HandleTrueObj);
    [X7,his7,ts7] = OBCD(X0,C,lambda,0,1e7,1,time_limit,1e-8,HandleTrueObj);
    
    %         figure;
    %         plot(ts1,his1,'c*');hold on;
    %         plot(ts2,his2,'g');hold on;
    %         plot(ts3,his3,'y');hold on;
    %         plot(ts4,his4,'k');hold on;
    %         plot(ts5,his5,'r');hold on;
    
    fprintf('objective value:\n');
    fprintf('%.5f %.5f %.5f ',HandleTrueObj(X1),HandleTrueObj(X2),HandleTrueObj(X3));
    fprintf('%.5f %.5f %.5f %.5f ',HandleTrueObj(X4),HandleTrueObj(X5),HandleTrueObj(X6),HandleTrueObj(X7));
    fprintf('\n');
    
    fprintf('sparsity:\n');
    fprintf('%.5f %.5f %.5f %.5f ',sparsity(X0),sparsity(X1),sparsity(X2),sparsity(X3));
    fprintf('%.5f %.5f %.5f %.5f ',sparsity(X4),sparsity(X5),sparsity(X6),sparsity(X7));
    fprintf('\n');
    
    
    One=[];
    One.his1 = his1; One.ts1 = ts1; One.f1 = HandleTrueObj(X1);
    One.his2 = his2; One.ts2 = ts2;One.f2 = HandleTrueObj(X2);
    One.his3 = his3; One.ts3 = ts3;One.f3 = HandleTrueObj(X3);
    One.his4 = his4; One.ts4 = ts4; One.f4 = HandleTrueObj(X4);
    One.his5 = his5; One.ts5 = ts5;One.f5 = HandleTrueObj(X5);
    One.his6 = his6; One.ts6 = ts6; One.f6 = HandleTrueObj(X6);
    One.his7 = his7; One.ts7 = ts7; One.f7 = HandleTrueObj(X7);
    
    fprintf('%.2f & %.2f & %.2f & %.2f & %.2f & %.2f & %.2f  & %.2f\n',...
        One.f1,    One.f2 , One.f3 , One.f4 ,One.f5  ,One.f6, One.f7);
    result{i_data_list} = One;
    
    savefile = sprintf('%s.mat',mfilename);
    save(savefile, 'result');
    
    
end
