function [X,fobjs,ts] = OBCD(X,C,lambda,f0,max_iter,WSS,timeLimit,myeps,HandleObj)
% A scalar t with abs(t) < myeps is regarded as 0
rand('seed',0);
randn('seed',0);
% WSS = 1: working set selection via random strategy
% WSS = 2: working set selection via cyclic strategy
% WSS = 3: working set selection via maximum violating pair
% WSS = 4: working set selection via maximum objective reduction pair


timeIntervel = timeLimit/20;
initt = clock;
last_rec_clock = initt;

ts = []; fobjs = [];
fobj = HandleObj(X);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];



[n,r]=size(X);
his = [];
CX = C*X;



theta = 1e-6;
I2 = eye(2);
% X = oproj(X);
B = [1;2];


if(WSS==2)
    Coordinate = GetRandomPerm(n);T = n*(n-1)/2;
end

if(WSS==3)
    G = CX ;
end

if(WSS== 4)
    Lip = norm_fast(C);
    G = CX  - Lip*X;
end

for iter = 1:max_iter
    
    %     F((UB*V*UB'+US*US')*X), s.t. V'V = I
    Z = X(B,:);
    ZZ = Z*Z';
    P = CX(B,:)*Z' - C(B,B)*ZZ - theta*I2;
    %     OO=(G*X');
    %     Q1 = Z*Z';
    %     Q2 = C(B,B);
    %     Q = kron(Q1,Q2);
    %     II = eye(2);
    %     OO(B,B) - reshape(Q*II(:),2,2)  - P
    
    % min_V 0.5*vec(V)'*Q*vec(V) + mdot(V,P) + lambda*||V*Z||_1, s.t. V'V=I
    %     V  = nonconvex_orth2d_quad_L0(kron(ZZ,C(B,B)),P,lambda,Z,myeps);
    V  = nonconvex_orth2d_quad_L0_cc(kron(ZZ,C(B,B)),P,lambda,Z(1,:),Z(2,:),r,myeps);
    %     V  = nonconvex_orth2d_quad_L0(kron(ZZ,C(B,B)),P,lambda,Z,myeps);
    X(B,:)  = V*X(B,:);
    
    % reconstruct the gradient in O(nr) time
    delta_CX = C(:,B)*(V-eye(2))*Z;
    CX  = CX + delta_CX;
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
%         fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
    

    if(WSS==1)
        B = randperm(n,2);
    elseif(WSS==2)
        %         B = cnext(B,n); B = cnext(B,n);
        B = Coordinate(mod(iter,T)+1,:);
    elseif(WSS==3)
        % Reconstruct G efficinetly in O(n*r)
        G = CX;
        P = 200;
        B = wws_greedy_maximum_violating_pair_cc(X',G',n,r,P);
        % B = wws_greedy_maximum_violating_pair(X,G,n,r,P);
        if (~mod(iter,2)),B = randperm(n,2);end
    elseif(WSS==4)
        % Reconstruct G efficinetly in O(n*r)
        G = G + delta_CX; G(B,:) = G(B,:) + Lip*(Z-X(B,:)) ;
        P = 200;
        B = wws_greedy_maximum_objective_reduction_pair_cc(X',G',n,r,P);
        if (~mod(iter,2)),B = randperm(n,2);end
    end
end


% function [fobj] = ComputeObjL0PCA(X,CX,lambda,myeps)
% fobj = 0.5*mdot(X,CX) + lambda * nnz3(X,myeps);


