function r = norm_fast(A)
% Estimate the spectral norm of A
% Note that it holds that r >= norm(A)

[m,n] = size(A);

for j=1:n
    his(j) = norm(A(:,j),1);
end

normA1 = max(his);

for i=1:m
    his(i) = norm(A(i,:),1);
end
normAinf = max(his);


bound1 = sqrt(m*n)*norm(A(:),inf);
bound2 = sqrt(n)*normA1;
bound3 = sqrt(m)*normAinf;
bound4 = norm(A,'fro');

r = min([bound1,bound2,bound3,bound4]);