% function demo_comparision
% min_X 0.5*mdot(X,C*X) + lambda*norm(X(:),1)
clc;clear all;close all;
maxNumCompThreads(1);
addpath('util','solver','../data');
rand('seed',1); randn('seed',1);

lambda = 500;

time_list   = [60];
data_list   = [1:10];
r_list      = [20];
lambda_list = lambda;

for i_data_list = 1:length(data_list)
    
    fprintf('================= start =================\n');
    time_limit = time_list(1);
    idat = data_list(i_data_list);
    r = r_list(1);
    lambda = lambda_list(1);
    dat_x = GetData(idat);
    C = - dat_x'*dat_x;
    HandleTrueObj = @(X)ComputeTrueObjL1PCA(X,C,lambda);
    n = size(C,1);
    
    
    
    fprintf(' time_limit: %d\n',time_limit);
    fprintf('       data: %d\n',idat);
    fprintf('          r: %d\n',r);
    fprintf('     lambda: %d\n',lambda);
    fprintf('          m: %d\n',size(dat_x,1));
    fprintf('          n: %d\n',size(dat_x,2));
    fprintf('sparsity(I): %f\n',(r)/(n*r));
    
    X0 = eye(n,r);
    X00 = RandomSparseOrth(n,r,0);
    [X1,his1,ts1] = RSS_L1PCA(X00,C,lambda,0,1e7,time_limit,HandleTrueObj);
    [X2,his2,ts2] = LADMM_L1PCA(C,lambda,r,X00,1e10,time_limit,HandleTrueObj);
    [X3,his3,ts3] = RSubGrad(C,n,r,lambda,X00,time_limit,HandleTrueObj);
    [X4,his4,ts4] = ADMM_L1PCA(C,lambda,r,X00,1e10,time_limit,HandleTrueObj);
    [X5,his5,ts5] = manpg_orth_sparse_adap(-0.5*C,n,r,lambda,X00,1e-4,30,1e7,time_limit,HandleTrueObj);
    [X6,his6,ts6] = OBCD(X0,C,lambda,0,1e7,1,time_limit);

    One=[];
    One.his1 = his1; One.ts1 = ts1; One.f1 = HandleTrueObj(X1);
    One.his2 = his2; One.ts2 = ts2;One.f2 = HandleTrueObj(X2);
    One.his3 = his3; One.ts3 = ts3;One.f3 = HandleTrueObj(X3);
    One.his4 = his4; One.ts4 = ts4; One.f4 = HandleTrueObj(X4);
    One.his5 = his5; One.ts5 = ts5;One.f5 = HandleTrueObj(X5);
    One.his6 = his6; One.ts6 = ts6; One.f6 = HandleTrueObj(X6);
    
    fprintf('%.2f & %.2f & %.2f & %.2f & %.2f & %.2f\n',...
        One.f1,  One.f2 , One.f3 , One.f4 ,One.f5  ,One.f6);
    result{i_data_list} = One;
    
    savefile = sprintf('%s.mat',mfilename);
    save(savefile, 'result');

end


