function [X,histroy,ts] = ADMM_L1PCA(C,mu,r,X,max_iter,time_limit,HandleTrueObj)
% min_{X} 0.5trace(X'CX) + mu*norm(X,1), X is orth
% min_{X,Y,Z} 0.5trace(Z'CZ) + mu*norm(Y,1), X = Y, Z = Y, X is orth
% L(X,Y,Z;pi,eta) = 0.5trace(Z'CZ) + mu*norm(Y,1) + <Y-X,pi>  + 0.5 beta ||Y-X||_F^2
%                                                 + <Z-Y,eta> + 0.5 beta ||Z-Y||_F^2
t00000 = clock();histroy = [];ts = [];
[n,r] = size(X);
   histroy = [histroy;HandleTrueObj(X)];
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];

    
% beta should be large enough, otherwize L could be unbounded.
beta = norm(C)*1.2;
Y =  X;
Z =  X;
pi = randn(n,r)*0;
eta = randn(n,r)*0;
% HandleObj = @(X,Y,Z) 0.5*trace(Z'*C*Z) + mu*norm(Y(:),1) + mdot(Y-X,pi)  + 0.5* beta*norm(Y-X,'fro')^2 + mdot(Z-Y,eta) + 0.5*beta*norm(Z-Y,'fro')^2;


 
for iter = 1:max_iter
    
    
    % min_X  <Y-X,pi>  + 0.5 beta ||X-Y||_F^2, s.t. X'X=I
    % min_X  0.5 beta ||X-(Y + pi/beta)||_F^2, s.t. X'X=I
    X = oproj(Y + pi/beta);
% histroy = [histroy;HandleObj(X,Y,Z)];

    % min_Y mu*norm(Y,1) + <Y-X,pi>  + 0.5 beta ||Y-X||_F^2 + <Z-Y,eta> + 0.5 beta ||Z-Y||_F^2
    % min_Y mu*norm(Y,1) + <Y,pi-eta>  + beta ||Y||_F^2 - beta <Y,X> - beta <Y,Z>
     B = pi - eta - beta*X - beta*Z;
    % min_Y mu*norm(Y,1)  + beta ||Y||_F^2 + <B,Y>
    % min_Y mu*norm(Y,1)  + beta ||Y + 0.5*B/beta||_F^2
    % min_Y 0.5*mu/beta*norm(Y,1)  + 0.5||Y + 0.5*B/beta||_F^2
     Y = prox_l1(-0.5*B/beta,0.5*mu/beta);
% histroy = [histroy;HandleObj(X,Y,Z)];


   % min_Z  0.5*trace(Z'*C*Z) + mdot(Z,eta) + 0.5*beta*norm(Z-Y,'fro')^2;
   % grad_Z= C*Z + eta + beta(Z-Y) = 0
   % grad_Z= (C+beta I)Z = beta Y - eta
    Z = (C+beta*eye(n))\(beta*Y-eta);
% histroy = [histroy;HandleObj(X,Y,Z)];

   


diff1 = Y-X;
diff2 = Z-Y;
pi = pi + beta*diff1;
eta = eta + beta*diff2;

%     X = prox_l1(Y-Z/beta,mu/beta);
%     O = X + Z/beta;
%     L = normC + beta;
%     grad = C*Y + beta*(Y-O);
%     Y = OrthProj(Y - grad/L);
%     diff = X - Y;
%     Z = Z + beta * diff;
   histroy = [histroy;HandleTrueObj(Y)];
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    if (cur_t > time_limit)
        break;
    end
    if ~mod(iter,30)
%         dist = max(norm(diff1),norm(diff2));
%         if(dist<1e-6)
        beta = min(1e10,beta * 2);
%         end
    end
end
% histroy
% 
