function [x,Lip,histroy]=AccerlatedProximalGradientMonotone(x,HandleObjSmooth,HandleObjNonSmooth,HandleProx,tot,Lip,time_limit)
% This program solves the following optimization problem:
% f(x) + g(x)
% where we assume that f is smooth g is non-smooth
% HandleObjSmooth:           x   ->  [fobj,grad]
% HandleObjNonSmooth:        x   ->  [fobj]
% HandleProx:          [theta,a] ->  arg min_{x} 0.5 theta || x - a ||^2 + g(x)

% One xample:

% function example_LeastR
% clear, clc;
% %  min  1/2 || A x - y||^2 + lambda * ||x||_1
% % f(x) + g(x)
% % 0.5 L ||x-xt||^2 + <x-xt,g> + g(x)
% % 0.5 L ||x-(xt-g/L)||^2 + g(x)
% % proximal mapping:
%
% % 0.5 theta ||x - a||^2 + g(x)
%
%
% m=1000;  n=100;    % The data matrix is of size m x n
% A=randn(m,n);       % the data matrix
% y = randn(m,1);
% lambda=0.2;
% HandleObjSmooth = @(x)computeObj(x,A,y);
% HandleObjNonSmooth = @(x)lambda*sum(abs(x));
% x=zeros(n,1);
% HandleProx = @(theta,a)computeprox(theta,a,lambda);
% [x1, his]= AccerlatedProximalGradient(x,HandleObjSmooth,HandleObjNonSmooth,HandleProx);
% plot(his)
%
% function [fobj,grad] = computeObj(x,A,y)
% diff = A*x-y;
% fobj = 1/2*norm(diff)^2 ;
% grad = A'*diff ;
%
% function [x] = computeprox(theta,a,lambda)
% % 0.5 theta ||x - a||^2 + g(x)
% [x] = threadholding_l1(a,lambda/theta);
%
% function [x] = threadholding_l1(a,lambda)
% % solving the following OP:
% % min_{x} 0.5 ||x - a||^2 + lambda * sum(abs(x))
% x = sign(a).*max(0,abs(a)-lambda);

% last modified: 2016-01-29

maxiter = 500;

y = x;
alpha = 1;
HandleObj = @(x)HandleObjSmooth(x)+ HandleObjNonSmooth(x);
f_best = HandleObj(x);
histroy(1)=f_best;
memory = 10;
t1 = clock();

exit_flag = -1;
for iter=1:maxiter
    if(etime(clock(),t1) > time_limit),exit_flag=0;break;end
    [f_old,g_old] = HandleObjSmooth(y);
    
    grad_y = g_old;
    fy = f_old;
    linesearch = 1;
    if(linesearch==0)
        L = Lip;
        % min_{x} 0.5 L ||x-(xt-g/L)||^2 + z * ||x||_1
        z = HandleProx(y - g_old/L,L);
        fz =  HandleObj(z);
    elseif(linesearch==1)
        Lip = Lip/2;
        max_in = 10;
        for in=1:max_in
            % min_{x} 0.5 L ||x-(xt-g/L)||^2 + z * ||x||_1
            z = HandleProx(y - g_old/Lip,Lip);
            fz = HandleObjSmooth(z);
            if CheckSmoothConstant(Lip,fz,fy,z,y,grad_y)
                break;
            else
                Lip = 2*Lip;
            end
        end
        if(in==max_in)
            fprintf('warning! Lipschitz too large!');
        end
 
        fz = fz + HandleObjNonSmooth(z);
    elseif(linesearch==2)
 
        for in = 1:200
            z = HandleProx(y - g_old/Lip,Lip);
            fz = HandleObjSmooth(z);
            CheckSmoothConstant(Lip,fz,fy,z,y,grad_y)
            if CheckSmoothConstant(Lip,fz,fy,z,y,grad_y)
                Lip = Lip/2;
            else
                break;
            end
        end


        Lip = Lip*2;
        z = HandleProx(y - g_old/Lip,Lip);
        fz = HandleObjSmooth(z);
        fz = fz + HandleObjNonSmooth(z);
        
    end
 
    
    alphap = alpha; alpha = (1+sqrt(4*alpha*alpha +1))/2;
    x_old = x;
    fx_old = HandleObj(x);
    if(fz<fx_old)
        x = z;
    else
        x = x;
    end
    
    y = x + (alphap/alpha)*(z-x) + ((alphap-1)/alpha)*(x-x_old);
    
    
    histroy(iter+1) = min(fx_old,fz);
    FDiff = abs(histroy(iter) - histroy(iter+1)) / (1+ abs((histroy(iter))));
    %  XDiff = s_norm / sqrt(n);
    if iter <= memory
        stop_seq_f(iter) = FDiff;
        %                 stop_seq_x(iter) = XDiff;
    else
        stop_seq_f  = [stop_seq_f(2:end) FDiff];
        %                 stop_seq_x  = [stop_seq_x(2:end); XDiff];
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % last_k_xtol=mean(stop_seq_x);
    last_k_ftol=mean(stop_seq_f);
    if (iter>50 && last_k_ftol <tot)
        if(histroy(end)<histroy(1))
            exit_flag = 1;
            break;
        end
    end
    
    
end
plot(histroy)
pause
