function [X,histroy,ts] = LADMM_L1PCA(C,mu,r,X,max_iter,time_limit,HandleTrueObj)
% min_{X} 0.5trace(X'CX) + mu*norm(X,1), X is orth
% min_{X} 0.5trace(Y'CY) + mu*norm(X,1), X = Y, Y is orth
% L(X,Y,Z) = 0.5trace(Y'CY) + mu*norm(X,1) + <X-Y,Z> + 0.5 beta ||X-Y||_F^2, s.t. Y is orth
t00000 = clock();histroy = [];ts = [];

histroy = [histroy;HandleTrueObj(X)];
cur_t = etime(clock(),t00000);
ts = [ts;cur_t];



% normC = abs(laneig((C+C')/2,1));
normC = norm(C);
beta = 50;
Z = randn(size(X))*0;
Y =  X + randn(size(X))*0.01;

for iter = 1:max_iter
    
    X = prox_l1(Y-Z/beta,mu/beta);
    histroy = [histroy;HandleTrueObj(Y)];
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    if (cur_t > time_limit)
        break;
    end
    O = X + Z/beta;
    L = normC + beta;
    grad = C*Y + beta*(Y-O);
    Y = OrthProj(Y - grad/L);
    diff = X - Y;
    Z = Z + beta * diff;
    if ~mod(iter,30)
        beta = min(1e10,beta * 2);
    end
end
