function [x, histroy,iter,NumEvaFun,NumEvaPro]=NesterovOptimalGradient(x,HandleObj,HandlePro,opts)
[n,k]=size(x);
NumEvaFun=0;
NumEvaPro=0;
opts.ftol = 1e-15;
opts.xtol = 1e-13;
ftol=opts.ftol;
xtol=opts.xtol;

%% The main program

if ~isfield(opts,'maxIter')
    opts.maxIter = 200;
end

bFlag=0; % this flag tests whether the gradient step only changes a little

%% The Armijo Goldstein line search scheme
L=1;
% assign xp with x, and Axp with Ax
xp=x;  xxp=zeros(n,k);
alphap=0; alpha=1;
for iter=1:300
    % --------------------------- step 1 ---------------------------
    % compute search point s based on xp and x (with beta)
    beta=(alphap-1)/alpha;    s=x + beta* xxp;
    [f_last,g]=HandleObj(s);NumEvaFun=NumEvaFun+1;
    % copy x and Ax to xp and Axp
    xp=x;
    
    while (1)
        v=s-g/L;
        % projection
        [x]=HandlePro(v);   NumEvaPro=NumEvaPro+1;
        [f_curr]=HandleObj(x);NumEvaFun=NumEvaFun+1;
        diff=x-s;  % the difference between the new approximate solution x
        r_sum1=0.5*norm(diff,'fro')^2;
        l_sum1=f_curr - f_last- trace(diff'* g);
        if (r_sum1 <=1e-20)
            bFlag=1; % this shows that,
            fprintf('the gradient step makes little improvement');
            break;
        end
        
        if(l_sum1 - r_sum1 * L <=0)
            break;
        end;
        L=max(2*L, l_sum1/r_sum1);
        
    end
    
    % --------------------------- step 3 ---------------------------
    % update alpha and alphap, and check whether converge
    alphap=alpha; alpha= (1+ sqrt(4*alpha*alpha +1))/2;
    
    xxp=x-xp;
    histroy(iter) = f_curr;
    histroy2(iter)= norm(xxp,'fro') / sqrt(n);
    
    if (bFlag)
        fprintf('\n The program terminates as the gradient step changes the solution very small.');
        break;
    end
    % check convergence
    if(iter>1)
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % 1. |X_k-X_k+1|_F / sqrt(n)  < xtol
        if(norm(xxp,'fro')/sqrt(n) < xtol),break;end
        % 2. |F(X_k-1) - F(X_k)| /  { |F(X_k-1)| + 1 }  < ftol
        if( (histroy(iter-1) - histroy(iter)) / (1+ abs((histroy(iter-1)))) < ftol),break;end
        % 3. last 5 histroy2 < 10* xtol
        if(mean(histroy2(iter - min(5,iter) + 1:iter))<10*xtol),break;end
        % 4. last 5 histroy < 10* ftol
        if(mean(histroy2(iter - min(5,iter) + 1:iter))<10*ftol),break;end
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
end

