function [X,histroy,ts] = OBCD(X,C,lambda,f0,max_iter,WSS,time_limit)
rand('seed',0);
randn('seed',0);
% WSS = 1: working set selection via random strategy
% WSS = 2: working set selection via cyclic strategy
% WSS = 3: working set selection via maximum violating pair
% WSS = 4: working set selection via maximum objective reduction pair
t00000 = clock(); ts=[]; histroy = [];
CX = C*X;
fobj = ComputeObjL1PCA(CX,X,lambda);
histroy = [histroy;fobj];
cur_t = etime(clock(),t00000);
ts = [ts;cur_t];



[n,r]=size(X);


% X = oproj(X);
B = [1;2];

if(WSS==2)
    Coordinate = GetRandomPerm(n);T = n*(n-1)/2;
end

if(WSS==3 )
    G = CX + lambda*SubgradL1(X);
end

if(WSS== 4)
    Lip = norm_fast(C);
    G = CX + lambda*SubgradL1(X) - Lip*X;
end

for iter = 1:max_iter
    
    %     F((UB*V*UB'+US*US')*X), s.t. V'V = I
    Z = X(B,:);
    ZZ = Z*Z';
    P = CX(B,:)*Z' - C(B,B)*ZZ;
    
    % min_V 0.5*vec(V)'*Q*vec(V) + mdot(V,P) + lambda*||V*Z||_1, s.t. V'V=I
    % V  = nonconvex_orth2d_quad_L1(kron(ZZ,C(B,B)),W,lambda,Z);
    V  = nonconvex_orth2d_quad_L1_cc(kron(ZZ,C(B,B)),P,lambda,Z(1,:),Z(2,:),r);
    X(B,:)  = V*X(B,:);
    
    % reconstruct the gradient in O(nr) time
    delta_CX = C(:,B)*(V-eye(2))*Z;
    CX  = CX + delta_CX;
    
    if(~mod(iter,2000))
        fobj = ComputeObjL1PCA(CX,X,lambda);
        histroy = [histroy;fobj];
        cur_t = etime(clock(),t00000);
        ts = [ts;cur_t];
        if (cur_t > time_limit)
            break;
        end
        %         fprintf('iter:%d, fobj:%f, f0:%f, diff:%f, sparsity:%f %f\n',iter,fobj,f0,fobj-f0,sparsity(X),1/n);
    end
    
    if(WSS==1)
        B = randperm(n,2);
    elseif(WSS==2)
        %         B = cnext(B,n);B = cnext(B,n);
        B = Coordinate(mod(iter,T)+1,:);
    elseif(WSS==3)
        % Reconstruct G efficinetly in O(n*r)
        G = G + delta_CX; G(B,:) = G(B,:) + lambda*SubgradL1(X(B,:)) - lambda*SubgradL1(Z);
        P = 200;
        B = wws_greedy_maximum_violating_pair_cc(X',G',n,r,P);
        %         B = wws_greedy_maximum_violating_pair(X,G,n,r,P);
        if (~mod(iter,2))
            B = randperm(n,2);
        end
        
    elseif(WSS==4)
        % Reconstruct G efficinetly in O(n*r)
        G = G + delta_CX; G(B,:) = G(B,:) + Lip*(Z-X(B,:)) + lambda*SubgradL1(X(B,:)) - lambda*SubgradL1(Z);
        P = 200;
        B  = wws_greedy_maximum_objective_reduction_pair_cc(X',G',n,r,P);
        %                 B  = wws_greedy_maximum_objective_reduction_pair(X,G,n,r,P);
        if (~mod(iter,2))
            B = randperm(n,2);
        end
    end
end

fobj = ComputeObjL1PCA(CX,X,lambda);
histroy = [histroy;fobj];
cur_t = etime(clock(),t00000);
ts = [ts;cur_t];

function [fobj] = ComputeObjL1PCA(CX,X,lambda)
fobj = 0.5*mdot(X,CX) + lambda * norm(X(:),1);
