function [X,fobjs,ts] = RSS_L1PCA(X,C,lambda,f0,max_iter,timeLimit,HandleObj)
% A scalar t with abs(t) < myeps is regarded as 0
rand('seed',0);
randn('seed',0);
% WSS = 1: working set selection via random strategy
% WSS = 2: working set selection via cyclic strategy
% WSS = 3: working set selection via maximum violating pair
% WSS = 4: working set selection via maximum objective reduction pair


timeIntervel = timeLimit/20;
initt = clock;
last_rec_clock = initt;

ts = []; fobjs = [];
fobj = HandleObj(X);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];



[n,r]=size(X);
his = [];
CX = C*X;



theta = 1e-6;
I2 = eye(2);
% X = oproj(X);
B = [1;2];




for iter = 1:max_iter

    gamma = 10   /  ( sqrt(iter+2) * log(iter+2) );
    B = randperm(r,2);
    N = setdiff([1:r],B);
 
% X = oproj(X);
% fobj =  mdot(X,C*X) + lambda * mynnz(X,myeps) ;% -trace(C)
% grad = 2*C*X;
% xi = grad(:,B) + lambda*sign(X(:,B)); 
xi = 2*C*X(:,B)+ lambda*sign(X(:,B)); 

    D = X(:,B)*skew(X(:,B)'*xi) + (eye(n) - X*X')*xi;
    S = X(:,B) - gamma*D;
    X(:,B) = proj_orth( (eye(n) - X(:,N)*X(:,N)')*S);
    
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeLimit/20)
        fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
%         fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
    
 
      
 
end




 
% plot(his)


% function [fobj] = ComputeObjL0PCA(X,CX,lambda,myeps)
% fobj = 0.5*mdot(X,CX) + lambda * nnz3(X,myeps);


function X = proj_orth(X)
[P, S, Q] = svd(X,0);
X = P*Q';

function r = skew(xi)
r = 0.5*(xi-xi');


function [fobj,grad] = ComputeObj(X,C)
fobj = -trace(X'*C*X);
grad = -2*C*X;
