function [X,histroy,ts] = RSubGrad(C,n,r,mu,X0,time_limit,HandleTrueObj)
% This programe solves the following problem using Remannian subgradient method:
% min_X 0.5*mdot(X,C*X) + mu*norm(X,1),
% s.t. X'*X=I_r
% X: n x r
t00000 = clock();histroy = [];ts = [];

max_iter = 10000000000;
X = X0;
for iter = 1:max_iter
    
    G = C*X + mu*sign(X) ;
    XtG = X'*G;
    RG = G - 0.5*X*(XtG+XtG');
    X = X - 0.1/iter * RG;
    X = oproj(X); % [U,S] = eig(X'*X);   s = diag(S);    X = X*(U*diag(sqrt(1./s))*U');
    histroy = [histroy;HandleTrueObj(X)];
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    if (cur_t > time_limit)
        break;
    end
    
end

% plot(fobj)


