function [X] = RandomSparseOrth(n,r,seed)
rand('seed',seed);
randn('seed',seed);

group = [];
for i=1:r
    group{i} = [];
end

sss = randperm(n);
for i=1:n
    g_id = mod(i,r)+1;
    group{g_id} = [group{g_id};sss(i)];
end

X = zeros(n,r);
for i=1:r
    www = group{i};
    c = length(www);
    X(www,i) = sign(randn(c,1)) / sqrt(c);
end


