function [c,s,fobj_best] =  nonconvex_quadratic_trigonometry_L1(A,B,C,D,E,lambda,x,y)
% min_{c,s} A*c + B*s + C*c*c + D*c*s + E*s*s + lambda*norm(c*x+s*y,1), s.t. c*c + s*s = 1

W = C-E;
max_val = 1e100;
list1 = [];

for i=1:length(x)
    tmp =  x(i) / y(i);
    if(tmp<=max_val && tmp >= - max_val)
        list1 = [list1;tmp];
    end
end

sort_list1 = sort(abs(list1));
list2 = [-max_val;-flip(sort_list1);sort_list1;max_val];


HandleObj_cs = @(c,s)A*c + B*s + C*c*c + D*c*s + E*s*s + lambda*norm(c*x + s*y,1);

c_list = [0;1;0;-1];
s_list = [1;0;-1;0];


for i = 1:length(list1)
    tt = - list1(i);
    c = 1 / sqrt(tt*tt+1);
    s = tt / sqrt(tt*tt+1);
    c_list  = [c_list;c];
    s_list  = [s_list;s];
    c_list  = [c_list;-c];
    s_list  = [s_list;-s];
end


for i = 1:(length(list2)-1)
    t = (list2(i) + list2(i+1))/2;
    o = sign(x + t*y);
    c00 = - lambda*mdot(o,y) - B;
    c11 = A  + lambda*mdot(o,x);
    c0 = D;
    c1 = - W*2;
    c2 = -D ;
    cof0 = c00*c00 - (c0 )*(c0);
    cof1 =  + 2*c00*c11    - (c0 )*(c1)  - (c1)*(c0);
    cof2 = c11*c11  + c00*c00 - c0*c2 - (c2)*(c0)    - (c1)*(c1);
    cof3 = 2*c00*c11   - (c2)*(c1)  - (c1)*(c2);
    cof4 = c11*c11 - c2*c2;
    critical_points = roots([cof4;cof3;cof2;cof1;cof0]);
    critical_points = real(critical_points);
    
    for ii=1:length(critical_points)
        ttt = critical_points(ii);
        if(ttt >= list2(i) && ttt<= list2(i+1) )
            cc = 1 / sqrt(1+ttt*ttt);
            ss = ttt /  sqrt(1+ttt*ttt);
            c_list = [c_list;cc];
            s_list = [s_list;ss];
%             c_list = [c_list;-cc];
%             s_list = [s_list;-ss];
        end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    o = sign(-x - t*y);
    c00 = -  lambda*mdot(o,-y) + B;
    c11 = -A   + lambda*mdot(o,-x);
    c0 = D;
    c1 = - W*2;
    c2 = -D ;
    cof0 = c00*c00 - (c0 )*(c0);
    cof1 =  + 2*c00*c11    - (c0 )*(c1)  - (c1)*(c0);
    cof2 = c11*c11  + c00*c00 - c0*c2 - (c2)*(c0)    - (c1)*(c1);
    cof3 = 2*c00*c11   - (c2)*(c1)  - (c1)*(c2);
    cof4 = c11*c11 - (c2)*(c2);
    
    critical_points = roots([cof4;cof3;cof2;cof1;cof0]);
    critical_points = real(critical_points);
    
    for ii=1:length(critical_points)
        ttt = critical_points(ii);
        if(ttt >= list2(i) && ttt<= list2(i+1) )
            cc = -1 / sqrt(1+ttt*ttt);
            ss = - ttt /  sqrt(1+ttt*ttt);
            c_list = [c_list;cc];
            s_list = [s_list;ss];
%             c_list = [c_list;-cc];
%             s_list = [s_list;-ss];
        end
    end
end
for iii=1:length(c_list)
    fobjs(iii) = HandleObj_cs(c_list(iii),s_list(iii));
end
[fobj_best,index]=min(fobjs);
c = c_list(index);
s = s_list(index);


