function [X,histroy,ts]=soc_spca(B,n,r,mu,tol,X0,time_limit)
%min -Tr(X'*A*X)+ mu*norm(X,1) s.t. X'*X=Ir.
% A = B  type = 1

t00000 = clock();histroy = [];ts = [];

maxiter = 100000;
A = -B;

h=@(X) mu*sum(sum(abs(X)));
%rho = svds(B,1)^2 + r/2;%  stepsize
%rho = svds(B,1)^2 + n*r*mu/25 + 1;
%rho = svds(B,1)^2 + n/50 ;% good for mu and r
rho = 2* svds(B,1)^2  ;%  n/30 not converge   1.9* sometimes not converge
lambda = rho;
P = X0;    Q = P;
Z = zeros(n,r);
b=Z;
F_ad=zeros(maxiter,1);

%chA = chol( 2*A + (r+lambda)*eye(d));
Ainv = inv( 2*A + (rho+lambda)*eye(n));

for itera=1:maxiter
    
    histroy = [histroy;HandleTrueObj(Y)];
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    if (cur_t > time_limit)
        break;
    end
    LZ = rho*(P-Z)+lambda*(Q-b);
    %   X=A_bar\LB;
    %  X = chA\(chA'\LZ);
    X = Ainv*LZ;
    X = min(1,X);
    X = max(-1,X);
    Q = sign(X+b).*max(0,abs(X+b)-mu/lambda);
    Y = X + Z;
    [U,~,V]= svd(Y,0);
    P = U*V';
    Z  = Z+X-P;
    b  = b+X-Q;
    if itera>2
        normXQ = norm(X-Q,'fro');
        normQ = norm(Q,'fro');
        normX = norm(X,'fro');
        normP = r;
        normXP = norm(X-P,'fro');
        if  normXQ/max(1,max(normQ,normX)) + normXP/max(1,max(normP,normX)) <tol
            AP = -(B*P);
            F_ad(itera)= sum(sum(X.*(AP)))+h(P);
        end
    end
end

X=P;


