function [x] = BreakPointSearch(d,a,s,oper)
% This program solves the following QP:
% min_x 0.5*x'*diag(d)*x + a'*x
% s.t. sum(x) oper s,  0 <= x <= 1
% oper can be '==', '>=', or '<='
% We assume d > 0.
% Reference:
% [1] Sparsity Constrained Minimization via Mathematical Programming with Equilibrium Constraints, arXiv, 2016.
% [2] A polynomially bounded algorithm for a singly constrained quadratic program. Mathematical Programming, 1980.

n = length(d);assert( s>=0 && s<=n );
y = sort([-a-d;-a],'ascend');
l = 1; r = 2*n; L = n; R = 0;
while 1
    if(r-l==1)
        S = (s-L)/(R-L);
        rho = y(l)+(y(r) - y(l))*S;
        break;
    else
        m = floor(0.5*(l+r));
        t = (-a-y(m))./d;
        C = sum(max(0,min(t,1)));
        if(C==s),
            rho = y(m);break;
        elseif(C>s)
            l = m;L=C;
        elseif(C<s)
            r = m;R=C;
        end
    end
end
if (oper(1)=='>')
    rho = min(rho,0);
elseif(oper(1)=='<')
    rho = max(rho,0);
end
t = (-a-rho)./d;
x = max(0,min(t,1));
