function X = computeprox(A,theta,mu)
% 0.5 theta ||X - A||^2 + mu*norm(X,1), s.t. ||X||_F^2 <= r

[n,r] = size(A);
X = prox_l1_ball2(A,mu/theta,r);
% min_X 0.5||X-A||_{fro}^2 + lambda ||X||_1, s.t. ||X||^2_F <= r




function X = prox_l1_ball2(A,lambda,r)
% min_X 0.5||X-A||_{fro}^2 + lambda ||X||_1, s.t. ||X||^2_F <= r


% a = A(:);
% n = length(a);
% cvx_begin
%    variable x(n)
%    minimize( -x'*a + lambda * norm(x,1) )
%    subject to
%    x'*x<=r
% cvx_end
% X = reshape(x,size(A));
% return;



Y = prox_l1(A,lambda);

% Y = Y + randn(size(Y))*1e-5;
% if(norm(Y,'fro')<1e-2)
%     Y = randn(size(A));
% end
X = proj_l2(Y,sqrt(r));





% [x] = prox_l12_vec(A(:),lambda,r);
% X = reshape(x,size(A));

function [x] = proj_l2_sphere(a,tau)
% min_{x} ||x-a||_2^2, s.t. ||x||_2 <= tau
x = tau*a / norm(a,'fro');

function [x] = prox_l12_vec(a,lambda,r)
% min_x 0.5||x-a||_2^2 + lambda ||x||_1, s.t. x'x <= r
% we assume that a >= 0
% min_x 0.5||x-a||_2^2 + lambda x'*1, s.t. x'x <= r
% min_x 0.5||x-a + lambda 1||_2^2, s.t. x'x <= r, x>=0
% min_x 0.5||x-(a - lambda 1)||_2^2, s.t. x'x <= r, x>=0
x = sign(a).*proj_l2_nn2(abs(a) - lambda,sqrt(r));

function [x] = proj_l2_nn2(a,r)
% min_{x} 0.5||x-a||_2^2, s.t. ||x||_2 <= r, x>=0

x = a;
x(x<0)=0;
norm_x = norm(x,'fro');

if(norm_x==0)
    x = rand(size(a));
    norm_x = norm(x,'fro');
    x = (x/norm_x) * r;
else
    x = (x/norm_x) * r;
end


% function test
%
% % min_x 0.5||x-a||_2^2 + lambda ||x||_1, s.t. x'x <= r
%
% n = 120;
% a = randn(n,1);
% lambda = 1.234;
% r = 24;
%
% cvx_begin
%    variable x(n)
%    minimize( 0.5*(x-a)'*(x-a) + lambda * norm(x,1) )
%    subject to
%    x'*x<=r
% cvx_end
%
% x1 = x
% [x2] = prox_l12(a,lambda,r);
% norm(x1-x2)
%

