function demo_prox_L212
% min_X 0.5||X-A||_{fro}^2 + lambda ||X||_{2,1}, s.t. ||X||_F <= sqrt(r)
% X: n x c
% A: n x c

for iter = 1:1000000000000

rand('seed',iter);
randn('seed',iter);
lambda = randperm(100,1)/100;

n = randperm(100,1);
c = 3;
r = randperm(100,1)/100; 
A = randn(n,c)*randperm(100,1)/100;



cvx_begin quiet
   variables X(n,c)
   minimize(0.5*(X(:,1)-A(:,1))'*(X(:,1)-A(:,1)) + 0.5*(X(:,2)-A(:,2))'*(X(:,2)-A(:,2)) + 0.5*(X(:,3)-A(:,3))'*(X(:,3)-A(:,3)) +   lambda * norm(X(:,1)) +   lambda * norm(X(:,2)) +   lambda * norm(X(:,3)) )
   subject to
   norm(X,'fro') <= sqrt(r)
cvx_end
 
fprintf('iter:%d\n',iter);
X1 = X; 

[X2] = prox_L212(A,lambda,r);
result = ComputeObj(X1,A,lambda,r) -  ComputeObj(X2,A,lambda,r);
if(result<0)
    iter
    ddd
end
end

function [fobj] = ComputeObj(X,A,lambda,r)
X=proj_l2(X,sqrt(r));
[n,c]=size(A);
fobj = 0.5*norm(X-A,'fro')^2;
for i=1:c,
    fobj = fobj + lambda * norm(X(:,i));
end

