function [X] = prox_l12_l2ball(A,lambda,r)
% min_X 0.5||X-A||_F^2 + lambda ||X||_{2,1}, s.t. ||X||_F^2 <= r
% ||X||_{2,1} the sum of the L2 norm of every column of A

[n,c]=size(A);
% step 1
% min_X 0.5||X-A||_F^2 + lambda ||X||_{2,1}, s.t. ||X||_F^2 <= r
% max_{theta1>=0} min_X 0.5||X-A||_F^2 + lambda ||X||_{2,1} + theta1 (0.5||X||_F^2 - 0.5 r)
% We now solve the X problem:
% min_X 0.5||X-A||_{fro}^2 + lambda ||X||_{2,1} + theta1 0.5||X||_F^2
% min_X 0.5(1+theta1) ||X||_F^2 - <X,A> + lambda ||X||_{2,1}

% step 2
% we consider the following problem:
% min_x 0.5 beta x'x - x'a + lambda ||x||_2
% min_x max_v 0.5 beta x'x - x'a + lambda <x,v>, ||v||_2<=1
% max_v min_x 0.5 beta x'x - x'a + lambda <x,v>, ||v||_2<=1
% beta x - a + lambda v = 0
% x = (a - lambda v) / beta
% max_v min_x 0.5 beta x'x - <x,a-lambda v>, ||v||_2<=1
% max_v min_x 0.5 beta^2 x'x - beta <x,a-lambda v>, ||v||_2<=1
% max_v 0.5 ||a - lambda v||_2^2 - ||a-lambda v||_2^2, ||v||_2<=1
% min_v 0.5 ||a - lambda v||_2^2, ||v||_2<=1
% min_v 0.5 ||a/lambda - v||_2^2, ||v||_2<=1
% v = P(a/lambda)
% x = a/beta - lambda v/ beta 
% x = a/beta - (lambda/beta)P(a/lambda)  

% step 3
% X_i = Ai/(1+theta1) - (lambda/(1+theta1))P(Ai/lambda)
% X_i = Qi / (1+theta1)

for i=1:c
    Q(:,i) =  A(:,i) - lambda * proj_l2(A(:,i)/lambda,1);
end

% max_{theta1>=0} min_X 0.5||X-A||_F^2 + lambda ||X||_{2,1} + theta1 (0.5||X||_F^2 - 0.5 r)
% max_{theta1>=0} sum_i^c { 0.5|| Qi / (1+theta1)-Ai||_2^2 + lambda ||Qi / (1+theta1)||_{2} + 0.5 theta1||Qi / (1+theta1)||^2 - 0.5 theta1 r }
% max_{theta1>=0} sum_i^c { 0.5 ||Qi / (1+theta1)||_2^2 + 0.5 ||Ai||_2^2 - <Qi / (1+theta1),Ai> + lambda ||Qi / (1+theta1)||_{2} + 0.5 theta1||Qi / (1+theta1)||^2 - 0.5 theta1 r }
% max_{theta1>=0} sum_i^c { 0.5/(1+theta1)^2 ||Qi||_2^2 - 1/(1+theta1)  <Qi,Ai> + lambda/(1+theta1) ||Qi||_{2} + 0.5 theta1/(1+theta1)^2 ||Qi ||^2 - 0.5 theta1 r }
% const = sum_i^c 0.5 ||Ai||_2^2

% max_{theta1>=0} 0.5/(1+theta1)^2 sum_i^c ||Qi ||_2^2 - 1/(1+theta1)  sum_i^c <Qi,Ai> + lambda/(1+theta1) sum_i^c||Qi||_{2} + 0.5 theta1/(1+theta1)^2 sum_i^c ||Qi ||^2 - 0.5 theta1 r c

% max_{theta1>=0} 0.5/(1+theta1)^2 cof1                - 1/(1+theta1)  cof2            + lambda/(1+theta1) cof3              + 0.5 theta1/(1+theta1)^2 cof4             - 0.5 theta1 r c

% cof1 = 0; cof2 = 0; cof3 = 0; cof4 = 0;
% for i=1:c
%     cof1 = cof1 + norm(Q(:,i))^2;
%     cof2 = cof2 + mdot(Q(:,i),A(:,i));
%     cof3 = cof3 + norm(Q(:,i));
%     cof4 = cof4 + norm(Q(:,i))^2;
% end
% max_{theta1>=0} 0.5/(1+theta1)^2 cof1                - 1/(1+theta1)  cof2            + lambda/(1+theta1) cof3              + 0.5 theta1/(1+theta1)^2 cof4             - 0.5 theta1 r c


%  HandleObj2 = @(theta1) (-0.5*cof1 + (1+theta1)*cof2            - lambda*(1+theta1)* cof3              - 0.5 * theta1 * cof4             + 0.5 * theta1 * r * c*(1+theta1)^2);
%   theta1  = fminbnd(HandleObj2,0,100);
 
% c0 = -0.5*cof1 + cof2 - lambda*cof3;
% c1 = cof2 -lambda* cof3   - 0.5 * cof4 + 0.5  * r * c*1;
% c2 =  r * c;
% c3 = 0.5 *  r * c;
% fff = @(theta1) -0.5*cof1 + (1+theta1)*cof2            - lambda*(1+theta1)* cof3              - 0.5 * theta1 * cof4             + 0.5 * theta1 * r * c*(1+theta1)^2;
% fff2 = @(theta1) c0 + c1*theta1  + c2*theta1^2 + c3*theta1^3;

% xs = [0:0.00001:0.0011];
% for i=1:length(xs)
%     fs(i) = fff2(xs(i));
% end
% plot(fs)


% fff(theta1)
% fff2(theta1)
% theta1  = fminbnd(fff2,0,100);
% theta1

% fff2(0) -  fff2(theta1)
 
% c1 + 2*c2*theta1 + 3*c3*theta1^2 == 0
% c1 + 2*c2*theta1 + 3*c3*theta1^2
%  theta1 = 0;
% cof_a = 3*c3;
% cof_b = 2*c2;
% cof_c = c1;
% (-cof_b + sqrt(cof_b*cof_b - 4*cof_a*cof_c) )/ (2*cof_a)
% ddd

%   X = Q / (1+theta1);
 
% norm(X,'fro')^2
% ddd
  X = Q ;
X=proj_l2(X,sqrt(r));
