function X = prox_l1_ball(A,lambda,r)
% min_X 0.5||X-A||_{fro}^2 + lambda ||X||_1, s.t. ||X||_F <= sqrt(r)
  [x] = prox_l12_vec(A(:),lambda,r);
% warning off;
% a = A(:);
% n = length(a);
% cvx_begin
%    variable x(n)
%    minimize( 0.5*(x-a)'*(x-a) + lambda * norm(x,1) )
%    subject to
%    x'*x<=r
% cvx_end

X = reshape(x,size(A));

function [x] = prox_l12_vec(a,lambda,r)
% min_x 0.5||x-a||_2^2 + lambda ||x||_1, s.t. x'x <= r
% we assume that a >= 0
% min_x 0.5||x-a||_2^2 + lambda x'*1, s.t. x'x <= r
% min_x 0.5||x-a + lambda 1||_2^2, s.t. x'x <= r, x>=0
% min_x 0.5||x-(a - lambda 1)||_2^2, s.t. x'x <= r, x>=0
x = sign(a).*proj_l2_nn2(abs(a) - lambda,sqrt(r));

function [x] = proj_l2_nn2(a,r)
% min_{x} 0.5||x-a||_2^2, s.t. ||x||_2 <= r, x>=0

x = a;
x(x<0)=0;
norm_x = norm(x,'fro');
 if(norm_x>r)
    x = (x/norm_x) * r;
 end

% function test
% 
% % min_x 0.5||x-a||_2^2 + lambda ||x||_1, s.t. x'x <= r
% 
% n = 120;
% a = randn(n,1);
% lambda = 1.234;
% r = 24;
% 

% 
% x1 = x
% [x2] = prox_l12(a,lambda,r);
% norm(x1-x2)
% 

