% min_X - 0.5*||AX||_F^2, s.t. X>=0
% min_X 0.5*X'CX, s.t. X>=0
% C = - A'A
clc;clear all;close all;
maxNumCompThreads(1);
addpath('util','solver','../data');
rand('seed',0);
randn('seed',0);


time_list   = [60];
data_list   = [1:10];
r_list      = [40];

for i_list_list = 1:length(time_list)
    for i_data_list = 1:length(data_list)
        for i_r_list = 1:length(r_list)
            %             f1s = []; f2s = []; f3s = [];
            %             e1s = []; e2s = []; e3s = [];
            idat = data_list(i_data_list);
            r = r_list(i_r_list);
            time_limit = time_list(i_list_list);
            
            fprintf('================= start =================\n');
            dat_x = GetData(idat);
            C = - dat_x'*dat_x;
            n = size(C,1);
            fprintf(' time_limit: %d\n',time_limit);
            fprintf('       data: %d\n',idat);
            fprintf('          r: %d\n',r);
            fprintf('          m: %d\n',size(dat_x,1));
            fprintf('          n: %d\n',size(dat_x,2));
            fprintf('sparsity(I): %f\n',(r)/(n*r));
            HandleObj = @(X)ComputeObjNonnegativePCA(X,C);
            HandleObjSurrogate = @(X)HandleObj(X)+norm(min(0,X),'fro')*1000;
            i_time=1;
            X00 = RandomPositiveOrth(n,r,1,i_time);            
            X0 = randn(n,r);
            X00 = eye(n,r);
            [X1,his1,ts1] = ADMM_NNPCA(C,r,X0,1e8,time_limit,HandleObjSurrogate);
            [X2,his2,ts2] = PADM_NNPCA(C,r,X0,1e8,time_limit,HandleObjSurrogate);
            [X3,his3,ts3] = RADMM_NNPCA(C,r,X0,1e8,time_limit,HandleObjSurrogate);
            [X4,his4,ts4] = OBCD(X00,C,inf,1e8,1,time_limit,HandleObjSurrogate);
            
            %                 f1 = HandleObj(X1); f2 = HandleObj(X2); f3 = HandleObj(X3);
            %                 e1 =  norm(min(0,X1),'fro'); e2 =  norm(min(0,X2),'fro'); e3 =  norm(min(0,X3),'fro');
            %                 f1s = [f1s;f1]; f2s = [f2s;f2]; f3s = [f3s;f3];
            %                 e1s = [e1s;e1]; e2s = [e2s;e2]; e3s = [e3s;e3];
            %              end
            
            %             fprintf('mean f1: %f %e\n',mean(f1s),mean(e1s));
            %             fprintf('mean f2: %f %e\n',mean(f2s),mean(e2s));
            %             fprintf('mean f3: %f %e\n',mean(f3s),mean(e3s));
            
            %             W1{i_data_list} = [mean(f1s);mean(f2s);mean(f3s);mean(f4s);mean(f5s);mean(f6s)];
            %             W2{i_data_list} = [mean(e1s);mean(e2s);mean(e3s);mean(e4s);mean(e5s);mean(e6s)];
            
            
            
            
            One=[];
            One.his1 = his1; One.ts1 = ts1; One.f1 = HandleObj(X1); One.e1 =  norm(min(0,X1),'fro');
            One.his2 = his2; One.ts2 = ts2; One.f2 = HandleObj(X2); One.e2 =  norm(min(0,X2),'fro');
            One.his3 = his3; One.ts3 = ts3; One.f3 = HandleObj(X3); One.e3 =  norm(min(0,X3),'fro');
            One.his4 = his4; One.ts4 = ts4; One.f4 = HandleObj(X4); One.e4 =  norm(min(0,X4),'fro');
            
            
            %     fprintf('%.2f & %.2f & %.2f & %.2f & %.2f & %.2f & %.2f  & %.2f\n',...
            %         One.f1,    One.f2 , One.f3 , One.f4 ,One.f5  ,One.f6, One.f7);
            result{i_data_list} = One;
            
            savefile = sprintf('%s.mat',mfilename);
            save(savefile, 'result');
            
            
            
        end
    end
end




