function [X,fobjs,ts] = ADMM_NNPCA(C,r,X,max_iter,timeLimit,HandleObjSurrogate)
% min_{X} 0.5trace(X'CX), X is orth
% min_{X} 0.5trace(X'CX), X = Y, Y is orth, X>=0
% L(X,Y,Z) = 0.5trace(X'CX) + <X-Y,Z> + 0.5 beta ||X-Y||_F^2, s.t. X>=0, Y is orth
initt = clock;
last_rec_clock = initt;
fobjs = [];ts = [];
fobjs = [fobjs;HandleObjSurrogate(X)];
cur_t = etime(clock(),initt);
ts = [ts;cur_t];
    
[n,r] = size(X);    
normC = abs(laneig((C+C')/2,1));
beta = 10;
Z = randn(size(X))*0;
Y = X;

for iter = 1:max_iter
    
    L = normC + beta;
    grad_X = C*X + Z + beta*(X-Y);
    X = X - grad_X / L;
    X = min(max(0,X),1);
    
    Y = OrthProj(X + Z/beta);
    Z = Z + beta * (X - Y);
    
 
    
    if ~mod(iter,30)
        beta = min(1e10,beta * 2);
    end
   
        cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeLimit/20)
        fobj = HandleObjSurrogate(Y);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
%         fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
    
    
end

X = max(0,Y);



