function [Best_X,histroy,ts] = ADMM_NonnegativePCA(A,r,X0,max_iter,time_limit)
% min_{X} trace(X'AX), X is orth, X>=0
% min_{X} trace(Y'AY) + mu*norm(X,1), X = Y, Y is orth
% L(X,Y,pi) = trace(Y'AY) + mu*norm(X,1) + <X-Y,Pi> + 0.5 beta ||X-Y||_F^2, s.t. Y is orth


X = X0;

% A = A + abs(laneig((A+A')/2,1))*eye(size(A,1));
HandleObjTrue  = @(X)ComputeObj(X,A);
Best_X_f = HandleObjTrue(X);
t00000 = clock();

scale = 10;



nr = size(X,1)* size(X,2);
normA = abs(laneig((A+A')/2,1));
rho_max = 2*normA*sqrt(r) ;
rho_max  = rho_max * 10;


rho = rho_max/(scale^20); %scale = 1;
rho = rho_max ; scale = 2;

rho = 1;
Pi = randn(size(X))*1;
ts = [];
histroy = [];
% Y =  OrthProj(randn(size(X)));
Y =  X;
% beta = 100;


for iter = 1:max_iter
    
    % update X
    % trace(Y'AY) + mu*norm(X,1) + <X-Y,Pi> + 0.5 beta ||X-Y||_F^2
    % mu*norm(X,1) + 0.5 beta ||X-Y + Pi/beta||_F^2
    [X] = max(0,Y-Pi/rho);
    O = X + Pi/rho;
    % HandleObj_X = @(Y)mdot(Y,A*Y) + 0.5*beta*norm(Y-O,'fro')^2;
    L = 2*normA + rho;
    %      L = 2*normA ;
    
    grad = 2*A*Y + rho*(Y-O);
    
    Y = OrthProj(Y - grad/L);
    
    diff = X - Y;
    Pi = Pi + rho * diff;
    true_fobj = HandleObjTrue(Y);
    dist = norm(diff,'fro');
    fprintf('iter:%d, dist: %f, fobj:%e, rho:%e\n',iter,dist,true_fobj,rho);
    
    histroy =[histroy;true_fobj];
    if(true_fobj< Best_X_f)
        Best_X = Y;
        Best_X_f = true_fobj;
    end
    
    
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    if (cur_t > time_limit),
        break;
    end
    
    if ~mod(iter,30) % && (dist > 1e-3)
        rho = min(1e10,rho * scale);
    end
    
    
end

Best_X = max(0,Y);


function [fobj] = ComputeObj(X,C)
fobj = 0.5*mdot(X,C*X);

