function [Best_X] = ADMM_NonnegativePCA2(C,B,r,X0,max_iter,time_limit)
% min_{X} 0.5trace(X'CX) - ||BX||_1, X is orth
% min_{X} 0.5trace(X'CX) - ||BX||_1, X = Y, Y is orth, X>=0
% L(X,Y,Z) = 0.5trace(X'CX) - ||BX||_1 + <X-Y,Z> + 0.5 beta ||X-Y||_F^2, s.t. X>=0, Y is orth

X = X0;
t00000 = clock();

normC = abs(laneig((C+C')/2,1));
beta = 1000;
Z = randn(size(X))*1;
ts = [];
Y =  X;

for iter = 1:max_iter
        cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    if (cur_t > time_limit)
        break;
    end
    for in=1:5
    % update X
    % L(X,Y,Z) = 0.5trace(X'CX) - ||BX||_1 + <X-Y,Z> + 0.5 beta ||X-Y||_F^2, s.t. X>=0, Y is orth
    % 0.5trace(X'CX) - ||BX||_1 + <X,Z> + 0.5 beta ||X-Y||_F^2, s.t. X>=0, Y is orth
    L = normC + beta;
 
    grad_X = C*X - B'*sign(B*X) + Z + beta*(X-Y);
    X = X - grad_X / L;
    X = max(0,X);

    
    % update Y
    % L(X,Y,Z) = 0.5trace(X'CX) - ||BX||_1 + <X-Y,Z> + 0.5 beta ||X-Y||_F^2, s.t. X>=0, Y is orth
    % <X-Y,Z> + 0.5 beta ||X-Y||_F^2, s.t. Y is orth
%     0.5 beta ||X-Y + Z/beta||_F^2, s.t. Y is orth
    Y = X + Z/beta;
    Y = OrthProj(Y);
    end
    
    diff = X - Y;
    Z = Z + beta * diff;
    dist = norm(diff,'fro');
    fprintf('iter:%d, dist: %f, beta:%e\n',iter,dist,beta);
    
    
    cur_t = etime(clock(),t00000);
    ts = [ts;cur_t];
    if (cur_t > time_limit) 
        break;
    end
    
    if ~mod(iter,30) % && (dist > 1e-3)
        beta = min(1e10,beta * 2);
    end
%     fobj = 0.5*trace(X'*C*X) - L1Norm(B*X) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
%     fobj
end

Best_X = max(0,Y);


function [fobj] = ComputeObj(X,C)
fobj = 0.5*mdot(X,C*X);

