function [X,his,ts] = OBCD(X,C,f0,max_iter,WSS,timeLimit,HandleObjSurrogate)


% min_X 0.5*mdot(X,C*X), X>=0, X'X=I
rand('seed',0);
randn('seed',0);
% WSS = 1: working set selection via random strategy
% WSS = 2: working set selection via cyclic strategy
% WSS = 3: working set selection via maximum violating pair
% WSS = 4: working set selection via maximum objective reduction pair

initt = clock;
last_rec_clock = initt;
his = [];ts = [];
his = [his;HandleObjSurrogate(X)];
cur_t = etime(clock(),initt);
ts = [ts;cur_t];
    
% fprintf('WSS:%d\n',WSS)
[n,r]=size(X);


% X = oproj(X);
B = [1;2];
CX = C*X;

if(WSS==2)
    Coordinate = GetRandomPerm(n);T = n*(n-1)/2;
end

if(WSS== 4)
    Lip = norm_fast(C);
%     Lip = norm(C);
end
I2 = eye(2);
I2 = I2(:);
G = zeros(n,r);
theta = 1e-6;
 
for iter = 1:max_iter
    
    Z = X(B,:);
    ZZ = Z*Z';
    Q = kron(ZZ,C(B,B));
    P = CX(B,:)*Z' - reshape(Q*I2,2,2) - theta*eye(2);
    
    % min_V 0.5*vec(V)'*Q*vec(V) + mdot(V,P), s.t. V'V=I
    % V  = nonconvex_orth2d_quad_nonnegative(Q,P,Z);
    V  = nonconvex_orth2d_quad_nonnegative_cc(Q,P,Z(1,:),Z(2,:),r);
    X(B,:)  = V*X(B,:);
    
    % reconstruct the gradient in O(nr) time
    delta_CX = C(:,B)*(V-eye(2))*Z;
    CX = CX + delta_CX;

%     if(~mod(iter,10000))
%         error = norm(min(0,X),'fro');
%         fobj = ComputeObjNonnegativePCA(X,C);
%         his = [his;fobj];
 
%         fprintf('iter:%d, fobj:%f, f0:%f, diff:%f, sparsity:%f %f, error: %e\n',iter,fobj,f0,fobj-f0,sparsity(X),1/n,error);
%     end
    
    if(WSS==1)
        B = randperm(n,2);
    elseif(WSS==2)
%         B = cnext(B,n);
%         B = cnext(B,n);
 B = Coordinate(mod(iter,T)+1,:);
    elseif(WSS==3)
        % Prepare the gredint G, time: O(2*P*r*m)
        % Note A(:,i): m x 1
        % G: n x r
        %G = zeros(n,r);
        P = 200;
        P = min(n,P);
        I = randperm(n,P);
        J = randperm(n,P);
        G(I,:) = CX(I,:);
        G(J,:) = CX(J,:);
        B = wws_greedy_maximum_violating_pair_cc(X',G',n,r,I,J,P);
        %         B = wws_greedy_maximum_violating_pair(X,G,n,r,I,J,P);
        if(~mod(iter,2))
            B = randperm(n,2);
        end
    elseif(WSS==4)
        % Prepare the subgredint G, time: O(2*P*r*m)
        % Note A(:,i): m x 1
        % G: n x r
        
        P = 200;
        P = min(n,P);
        % Compute the subgradient for I and J
        I = randperm(n,P);
        J = randperm(n,P);
        G(I,:) = CX(I,:) - Lip*X(I,:);
        G(J,:) = CX(J,:) - Lip*X(J,:);
        B = wws_greedy_maximum_objective_reduction_pair_cc(X',G',n,r,I,J,P);
        %          B = wws_greedy_maximum_objective_reduction_pair(X,G,n,r,I,J,P);
        if(~mod(iter,2))
            B = randperm(n,2);
        end
    end
    
               cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeLimit/20)
        fobj = HandleObjSurrogate(X);
        ElasTime =  etime(cur_clock,initt);
        his  = [his;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
%         fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
end


