function V = nonconvex_orth2d_quad_nonnegative(Q,P,Z)
% This propram solves the following problem globally:
% min_V 0.5*vec(V)'*Q*vec(V) + mdot(V,P)
% s.t. V'V=I_2 and V*Z>=0

Z1 = Z(1,:);
Z2 = Z(2,:);
eps = 2.2204e-16;
% ZZ = abs(Z); norm1 = sqrt(sum(ZZ,1)); Z = Z(:, find(norm1>eps));
delete_index = [];
for i=1:size(Z,2)
        if(  (abs(Z1(i))>eps)   ||   (abs(Z2(i))>eps)  )
        else
            delete_index  =  [delete_index;i];
        end
 end
    
Z(:,delete_index) = [];

HandleObj = @(V)0.5*vec(V)'*Q*vec(V) + mdot(V,P);
% V0 = eye(2);
% f0 = HandleObj(V0);
[V1,f1] = nonconvex_orth2d_quad_nonnegative_R(Q,P,Z);
[V2,f2] = nonconvex_orth2d_quad_nonnegative_F(Q,P,Z);
if(f1 <= f2)
    V = V1;
else
    V = V2;
end

% if(f0<=f1 && f0 <= f2)
%     V = V0;
% elseif(f1<=f0 && f1 <= f2)
%     V = V1;
% elseif(f2<=f0 && f2 <= f1)
%     V = V2;
% end

function [V,fobj] = nonconvex_orth2d_quad_nonnegative_F(Q,P,Z)
% 0.5*vec(V)'*Q*vec(V) + mdot(V,P), V*Z>=0
% V = [-cos(theta) sin(theta);
%       sin(theta) cos(theta)];
cof_a = - P(1,1) + P(2,2);
cof_b = P(1,2) + P(2,1);
cof_c =  0.5*Q(1,1)+ 0.5*Q(4,4) - Q(1,4) ;
cof_e =  0.5*Q(2,2)  + 0.5*Q(3,3) + Q(2,3);
cof_d =  - Q(1,2) - Q(1,3) + Q(2,4) + Q(3,4);
cof_r = -Z(1,:)';
cof_s = Z(2,:)';
cof_p = Z(2,:)';
cof_u = Z(1,:)';
cof_x = [cof_r;cof_p];
cof_y = [cof_s;cof_u];


[c,s,fobj] = nonconvex_quadratic_trigonometric_nonnegative(0,cof_a,cof_b,cof_c,cof_d,cof_e,cof_x,cof_y);
% [c1,s1,fobj1] = nonconvex_quadratic_trigonometric_nonnegative_cc(cof_a,cof_b,cof_c,cof_d,cof_e,cof_x,cof_y,length(cof_x));
% if( abs(fobj1  - fobj)>1e-7)
%     fobj
%     fobj1
%     cof_x
%     cof_y
%     save why cof_a cof_b cof_c cof_d cof_e cof_x cof_y
%     ddd
% end


V = [-c s;s c];


function [V,fobj] = nonconvex_orth2d_quad_nonnegative_R(Q,P,Z)
% 0.5*vec(V)'*Q*vec(V) + mdot(V,P), V*Z>=0
% V = [cos(theta) sin(theta);
%     -sin(theta) cos(theta)];
cof_a = P(1,1) + P(2,2);
cof_b = P(1,2) - P(2,1);
cof_c =  0.5*Q(1,1)+ Q(1,4) + 0.5*Q(4,4);
cof_e =  0.5*Q(2,2) - Q(2,3) + 0.5*Q(3,3);
cof_d =  - Q(1,2) + Q(1,3) -Q(2,4) + Q(3,4);
cof_r = Z(1,:)';
cof_s = Z(2,:)';
cof_p = Z(2,:)';
cof_u = -Z(1,:)';
cof_x = [cof_r;cof_p];
cof_y = [cof_s;cof_u];

[c,s,fobj] = nonconvex_quadratic_trigonometric_nonnegative(1,cof_a,cof_b,cof_c,cof_d,cof_e,cof_x,cof_y);
% [c1,s1,fobj1] = nonconvex_quadratic_trigonometric_nonnegative_cc(cof_a,cof_b,cof_c,cof_d,cof_e,cof_x,cof_y,length(cof_x));

% c - c1
% s - s1

% if( abs(fobj1  - fobj)>1e-7)
%     fobj1
%     fobj
%         cof_x
%     cof_y
%         save why cof_a cof_b cof_c cof_d cof_e cof_x cof_y
%     ddd
% end


V = [c s;-s c];


