
function [cof_cos,cof_sin,minfobj] = nonconvex_quadratic_trigonometric_nonnegative(a,b,c,d,e,x,y)
% This program solves the following problem:
% min_{theta} a cos(theta) + b sin(theta) + c cos(theta)^2 + d cos(theta) sin(theta) + e sin(theta)^2
% s.t. cos(theta) x + sin(theta) y >=0
LARGE = 1e100;
eps = 2.2204e-16;


% fprintf('a:%f\n',a);
% fprintf('b:%f\n',b);
% fprintf('c:%f\n',c);
% fprintf('d:%f\n',d);
% fprintf('e:%f\n',e);
% x'
% y'

original_x = x;
original_y = y;

del_index = find(abs(y)<eps);
x(del_index)=[];
y(del_index)=[];

% find all the critical points without bounds
[critical_points] = get_all_critical_points(a,b,c,d,e);

I = find(y>0); J = find(y<0);

% Get the four parameters lb1, ub1, lb2, ub2
%%%%% We consider the first case
if(isempty(J))
    ub1 = LARGE;
    lb2 = -LARGE;
else
    ub1 = min(-x(J)./y(J));
    lb2 = max(-x(J)./y(J));
end
if(isempty(I))
    lb1 = -LARGE;
    ub2 = LARGE;
else
    lb1 = max(-x(I)./y(I));
    ub2 = min(-x(I)./y(I));
end

% Very critical!
cos_list = [1;0;-1;0];
sin_list = [0;1;0;-1];

% Case 1
if(ub1>=lb1)
    candidate_solution_case1=[];
    if(ub1<LARGE)
        candidate_solution_case1=[candidate_solution_case1;ub1];
    end
    if(lb1>-LARGE)
        candidate_solution_case1=[candidate_solution_case1;lb1];
    end
    P = @(t)min(ub1,max(lb1,t));
    candidate_solution_case1 = [candidate_solution_case1;P(critical_points)];
    for iii=1:length(candidate_solution_case1)
        t_case_1 = candidate_solution_case1(iii);
        chi = 1/sqrt(1+t_case_1*t_case_1);
        cos_theta1 = chi;
        sin_theta1 = t_case_1*chi;
        cos_list = [cos_list;cos_theta1];
        sin_list = [sin_list;sin_theta1];
    end
end

if(ub2>=lb2)
    candidate_solution_case2 = [];
    if(lb2>-LARGE)
        candidate_solution_case2=[candidate_solution_case2;lb2];
    end
    if(ub2<LARGE)
        candidate_solution_case2=[candidate_solution_case2;ub2];
    end
    P = @(t)min(ub2,max(lb2,t));
    candidate_solution_case2 = [candidate_solution_case2;P(critical_points)];
    for iii=1:length(candidate_solution_case2)
        t_case_2 = candidate_solution_case2(iii);
        chi = 1/sqrt(1+t_case_2*t_case_2);
        cos_theta2 = -chi;
        sin_theta2 = -t_case_2*chi;
        cos_list = [cos_list;cos_theta2];
        sin_list = [sin_list;sin_theta2];
    end
end

for ii=1:length(cos_list)
    fobjs(ii) = ComputeObj_cos_sin(cos_list(ii),sin_list(ii),a,b,c,d,e,original_x,original_y);
end


[minfobj,index] = min(fobjs);
if(minfobj==LARGE)
    cof_cos = 1;
    cof_sin = 0;
else
    cof_cos=cos_list(index);
    cof_sin=sin_list(index);
end


% % debug!!!!
% [cof_cos2,cof_sin2,flag2] = bps_nonnegative_quadratic_v3(a,b,c,d,e,original_x,original_y);
%
% if(flag==1 && flag2==1)
%     f1=ComputeObjRotation(cof_cos,cof_sin,a,b,c,d,e,original_x,original_y);
%     f2=ComputeObjRotation(cof_cos2,cof_sin2,a,b,c,d,e,original_x,original_y);
%     if(f2 <= f1- 1e-4)
%         error('Too Large');
%     end
% end

function [fobj] = ComputeObj_cos_sin(cos_theta,sin_theta,a,b,c,d,e,original_x,original_y)
LARGE = 1e100;
eps = 2.2204e-16;
dist = original_x*cos_theta + original_y*sin_theta;
hhh = find(dist<-eps);
if(isempty(hhh))
    fobj = a*cos_theta + b*sin_theta  + c*cos_theta*cos_theta + d*cos_theta*sin_theta + e*sin_theta*sin_theta;
else
    fobj = LARGE;
end



function [x] = get_all_critical_points(a,b,c,d,e)
% This program get the critical points of the following unconstrainted problem:
%          +/-  a  +/-  bt           c - e + d*t
% min_t  -------------------   +   -----------------
%            sqrt(1+t*t)               1+t*t

w = c -e;
c0 = d*d - b*b;
c1 = 2*b*a - 4*d*w;
c2 = 4*w*w - 2*d*d -a*a - b*b;
c3 = 4*w*d + 2*a*b;
c4 = d*d - a*a;

% grad = @(t)c0 + c1*t +c2*t*t + c3 * t*t*t + c4*t*t*t*t ;
ts = roots([c4;c3;c2;c1;c0]);
x = real(ts);
if(isempty(x))
    x = 0;
end



