#include "mex.h"
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <blas.h>    // dgemv
#include <lapack.h>  // dstegr
#include <string.h>
#include <omp.h>
#include <iostream>
//#include <iomanip>
using namespace std;

#define  abs1(a)         ((a) < 0.0 ? -(a) : (a))
#define  sign1(a)        ((a)==0) ? 0 : (((a)>0.0)?1:(-1))
#define  max1(a,b)       ((a) > (b) ? (a) : (b))
#define  min1(a,b)       ((a) < (b) ? (a) : (b))
# define PI 3.141592653589793238463L
# define M_2PI (2 * PI)
# define eps 2.2204e-16
# define LARGE 1e100

void pvec(double *x,int n)
{
    int i;
    for(i=0;i<n;i++)
    {
        printf("%f ",x[i]);
    }
    printf("\n ");
}

inline double dot1(const double*a,const double*b,const ptrdiff_t n)
{
    double ret = 0;
    ptrdiff_t i;
    for(i=0;i<n;i++) ret +=a[i]*b[i];
    return ret;
}

void wws_greedy_maximum_violating_pair_cc(double *X_transpose,double*G_transpose,int n, int r,double*I,double*J,int P, double*B)
{
    int i;
    double max_val = -LARGE;
    B[0]=1; B[1]=2;
    for(i=0;i<P;i++)
    {
        int i_test = I[i];
        int j_test = J[i];
        if(i_test==j_test)continue;
        double *Gi = G_transpose + r*(i_test-1);
        double *Gj = G_transpose + r*(j_test-1);
        double *Xi = X_transpose + r*(i_test-1);
        double *Xj = X_transpose + r*(j_test-1);
        double Dij = dot1(Xi,Gj,r) - dot1(Gi,Xj,r);
        Dij = abs1(Dij);
        if(Dij>max_val)
        {   max_val = Dij;
            B[0] = i_test; B[1] = j_test;
        }
        
    }
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    double *X_transpose       =  mxGetPr(prhs[0]);
    double *G_transpose       =  mxGetPr(prhs[1]);
    int n                     =  (int)mxGetScalar(prhs[2]);
    int r                     =  (int)mxGetScalar(prhs[3]);
    double *I                 =  mxGetPr(prhs[4]);
    double *J                 =  mxGetPr(prhs[5]);
    int P                     =  (int)mxGetScalar(prhs[6]);
    
    plhs[0] = mxCreateDoubleMatrix(2,1,mxREAL);
    double *B = mxGetPr(plhs[0]);
    wws_greedy_maximum_violating_pair_cc(X_transpose,G_transpose,n,r,I,J,P,B);
    
}
